/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.excel.errors;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import org.jetbrains.annotations.PropertyKey;

public class OlapExcelBuilderErrorCode extends OlapBuilderErrorCode
{
    private static final long serialVersionUID = -5201483642647657616L;

    public static final OlapExcelBuilderErrorCode EXCEL_SHEET_IS_EMPTY = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_SHEET_IS_EMPTY");

    public static final OlapExcelBuilderErrorCode EXCEL_SHEET_NOT_FOUND = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_SHEET_NOT_FOUND");

    public static final OlapExcelBuilderErrorCode EXCEL_FILE_NOT_FOUND = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_FILE_NOT_FOUND");

    public static final OlapExcelBuilderErrorCode EXCEL_FILE_INCORRECT_CONTENT = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_FILE_INCORRECT_CONTENT");

    public static final OlapExcelBuilderErrorCode EXCEL_FILE_READING_ERROR = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_FILE_READING_ERROR");

    public static final OlapExcelBuilderErrorCode EXCEL_UNSUPPORTED_CELL_TYPE = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_UNSUPPORTED_CELL_TYPE");

    public static final OlapExcelBuilderErrorCode EXCEL_COLUMN_NAME_IS_EMPTY = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_COLUMN_NAME_IS_EMPTY");

    public static final OlapExcelBuilderErrorCode EXCEL_INCORRECT_CELL_TYPE_FOR_COLUMN = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_INCORRECT_CELL_TYPE_FOR_COLUMN");

    public static final OlapExcelBuilderErrorCode EXCEL_FORMULA_EVALUATION_EXCEPTION = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_FORMULA_EVALUATION_EXCEPTION");

    public static final OlapExcelBuilderErrorCode EXCEL_ERROR_PROCESSING_LINE = new OlapExcelBuilderErrorCode("BUILDER_EXCEL_ERROR_PROCESSING_LINE");

    protected OlapExcelBuilderErrorCode(@PropertyKey(resourceBundle = "crazydev.iccube.builder.excel.errors.OlapExcelBuilderErrorCode") String value)
    {
        super(value);
    }

}
