/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.excel.datasource;

import crazydev.iccube.builder.type.OlapBuilderInputType;

public enum OlapBuilderExcelType
{
    EXCEL_NUMERIC(OlapBuilderInputType.DOUBLE),
    EXCEL_DATE(OlapBuilderInputType.DATETIME),
    EXCEL_STRING(OlapBuilderInputType.STRING),
    EXCEL_BOOLEAN(OlapBuilderInputType.BOOLEAN),
    EXCEL_BLANK(OlapBuilderInputType.STRING),
    EXCEL_UNDEFINED(OlapBuilderInputType.STRING);

    private OlapBuilderInputType type;

    OlapBuilderExcelType(OlapBuilderInputType type)
    {
        this.type = type;
    }

    public OlapBuilderInputType getType()
    {
        return type;
    }
}
