/*
 * Copyright 2014 - 2018 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.excel.datasource;

import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.validation.OlapBuilderNonEmptyDataTableValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import org.apache.poi.ss.usermodel.Sheet;

public class OlapBuilderExcelDataTableValidator extends OlapBuilderNonEmptyDataTableValidator<OlapBuilderExcelConnection, IOlapBuilderDataSource<OlapBuilderExcelConnection>>
{
    @Override
    protected boolean checkTableExists(OlapRuntimeContext context, OlapBuilderExcelConnection connection, IOlapBuilderDataTableDef<OlapBuilderExcelConnection> dataTable)
    {
        final Sheet sheet = connection.getSheet((OlapBuilderExcelDataTable) dataTable);
        return sheet != null;
    }

    protected void validateColumnWithTableColumn(OlapBuilderValidationContext context,
                                                 IOlapBuilderDataTableDef<OlapBuilderExcelConnection> dataTable,
                                                 IOlapBuilderDataColumnDef selectedColumn,
                                                 IOlapBuilderDataColumnDef selectedColumnFromDS)
    {
        final String tableType = selectedColumn.getTableType();
        final String tableTypeFromDS = selectedColumnFromDS.getTableType();

        if (!OlapBuilderExcelType.EXCEL_UNDEFINED.toString().equals(tableTypeFromDS) && (tableType != null ? !tableType.equals(tableTypeFromDS) : tableTypeFromDS != null))
        {
            final String name = dataTable.getName() + "." + selectedColumn.getName();

            context.addError(OlapBuilderErrorCode.COLUMN_HAS_INCORRECT_TYPE, name, tableType, tableTypeFromDS);
        }
    }

}
