L'expression est définie en utilisant la syntaxe du langage de balisage markdown (GitHub Flavored Markdown (GFM))
([www](https://www.markdownguide.org/basic-syntax/)). Le texte peut aussi contenir du code HTML.

Les expressions peuvent afficher à la fois du texte statique et du texte dynamique lié aux données sous-jacentes grâce aux accesseurs de
données. Un accesseur de données est essentiellement le nom d'une colonne de la table des résultats de la requête entre accolades.

#### Data Accessors

La syntaxe complète des accesseurs de données est la suivante:

```
    {colonne.modificateur.function()}
```

**Colonne**

Le nom d'une colonne dans la table des résultats de la requête ou le nom d'une association de données utilisé pour
sélectionner la colonne (par exemple, valeur dans le graphique à colonnes). Utilisez la complétion pour obtenir tous les
noms disponibles.

Sans aucun modificateur, `{column}` renvoie la valeur totale de la colonne.

Notez que toute **transformation** peut être utilisée comme valeur pour une expression. Vous êtes donc libre d'utiliser
n'importe quel formule pour calculer la valeur que vous souhaitez afficher.

**Modificateur**

Un modificateur doit être ajouté au nom de la colonne pour déterminer la valeur à afficher (par exemple, total, average). 
Les modificateurs actuels sont: total, average, median, min et max. Utilisez la complétion pour obtenir tous les
modificateurs disponibles.

Le modificateur `caption` permet de récupérer le nom localisé de la colonne:

```
    $column.caption$ : $column.total$
```

sera affiché comme:

```
    Amount : 42
```

**Function**

Un appel de fonction *facultatif* peut être utilisé pour formater la valeur à afficher. Plus d'informations à ce sujet
plus loin dans ce document. Notez que l'appel de la fonction `value()` est utilisé pour récupérer la valeur réelle sans
qu'aucune mise en forme ne soit appliquée. Utilisez la complétion pour obtenir toutes les fonctions disponibles.

**Mise en Forme**

Sans aucun appel de fonction de format spécifié, la valeur est formatée à l'aide de la propriétée MDX FORMAT_STRING.
Lorsque la propriétée FORMAT_STRING n'est pas disponible, un formateur par défaut (tel que configuré dans le thème de
votre rapport) est utilisé.

- formatDate(): sans aucun paramètre de mise en forme, le format de date par défaut est utilisé.

- formatNumber(): sans aucun paramètre de mise en forme, le format de nombres par défaut est utilisé.

- formatAmount() / formatPercent(): sans aucun paramètre de mise en forme, le format de nombres par défaut est utilisé.
  Sinon, formatNumber() est utilisé.

L'argument de format *facultatif* suit [formateurs amCharts 4](https://www.amcharts.com/docs/v4/concepts/formatters/).
Par example:

```
    {value.total.formatNumber("#,###.00")}
```

Notez que tous les formateurs supplémentaires définis dans le thème de votre rapport sont également disponibles en tant
que formateurs. Utilisez la complétion pour obtenir toutes les fonctions de format disponibles.

**Complétion**

Notez que la complétion de code est disponible dans un accesseur de données `{}` en utilisant `CTRL-SPACE`.

**Échappement**

Si vous avez besoin d'utiliser `{}` dans votre expression, vous devrez les échapper en les dupliquant. Par example, en
supposant que la colonne `Count{0}` existe et son total égal à `42`, l'expression suivante:

```
    {{0}}: {Count{{0}}}
``` 

va être affiché comme:

```
    0: 42
```

Ne pas oublier d'échapper `{}` à l'intérieur du paramêtre des fonctions de mise en forme.

Si vous avez besoin d'utiliser un `.` comme nom de colonne, vous devrez l'échapper en le dupliquant. Notez que les
espaces sont autorisés dans un nom de colonne. Par exemple, en supposant que la colonne `Amount Ex.` existe et son total
égal à `42`, l'expression suivante:

```
    {Amount Ex...total}
``` 

va être affiché comme:

```
    42
```

_

