## Walkthrough (Localization)

To demonstrate the MDX schema localization features we're going to create a simple schema analysing sales
across different countries. We assume the reader is familiar with schema creation as described in the previous
[walkthrough](walkthrough.md).

### Overview

Localizing a MDX schema is about providing alternate values for the captions of MDX members as well as captions
of dimensions, hierarchies, levels, etc.. for each locale (or language) you'd like to support. When no caption
is defined, the *regular* name of these MDX entities is used.

### MDX Member Localization

Localization of member captions is achieved using
the `@MC_locale` [member custom property](../../mdx/Member%20Custom%20Property.md).
This is a pre-defined icCube property that as described in this [page](../schemas_cubes/localization.md).
For the purpose of this walkthrough, we're going to localize in French the members of the `[Geo]` dimension;
therefore, we're going to define the `@MC_fr` property that is referencing the `caption_fr` column in the table
defining the `[Geo]` dimension:

![french localization](img/localization/@mc_fr_large.png)

The content of the dimension table is as following :

```
name          , caption_fr , caption_es     , caption_zh
France        , France     , Francia        , 法国
Spain         , Espagne    , España         , 西班牙
United States , États-Unis , Estados Unidos , 美国
```

### Dimension, Hierarchy, ... Localization

On top of member captions, icCube allows for localizing all MDX entities: e.g., dimensions, hierarchies,
levels, etc... This is done through a localization data-table that contains string columns. By convention,
the first column contains the unique names of the MDX entities to localize. All other columns contain
the caption of the entities for each locale you'd like to support. The name of the columns correspond
to the name of the locale as described [here](../schemas_cubes/localization.md). Below you can find
the table content localizing different MDX entities in French, Spanish and Chinese:

![localization table](img/localization/localization_table_large.png)

It is possible to generate a template file with all the values to localize using the XLS icon in the localization
use case. Notice how measures and measures groups (aka. facts in the icCube builder) are prefixed with the cube name.
This is mandatory when having several cubes in the schema and optional if a single cube is used. The `All` members
(and their levels) are localized using this table as those members do not defined by the dimension tables. As the
last point, even if they are not created in the template file, calculated members and sets can be localized as well
using this table.

![localization table template](img/localization/xls_generate_large.png)

Following is the content of the localization table that contains locale columns for the different languages :

```
unique_name                       , fr                         , es                        , zh
[Geo]                             , Géo                        , Geo                       , 地理
[Geo].[Geo]                       , Géo                        , Geo                       , 地理
[Geo].[Geo].[Country]             , Pays                       , País                      , 国家
[Geo].[Geo].[All Regions (Level)] , Toutes les Régions (Niveau), Todas las Regiones (Nivel), 所有地区
[Geo].[Geo].[All Regions]         , Toutes les Régions         , Todas las Regiones        , 所有地区
[Analytics]                       , Analyses                   , Análisis                  , 分析
[Analytics].[Sales]               , Ventes                     , Ventas                    , 销售
[Analytics].[Measures].[Amount]   , Montant                    , Cantidad                  , 量
```

### Last Words

That's about it. This tutorial has demonstrated how to fully localize a schema. Now, depending on the client
application you're using to access it (e.g., Excel pivot table) you'll discover dimension, hierarchy, etc... and
members captions according to the user's locale. As an example, the following picture is browsing the schema from
the icCube IDE application using the French locale :

![french browse](img/localization/localized_browing_large.png)

### Download

The schema of this example is available for download [here](data/walkthrough_localization.zip).

_