## Schema Scheduler

icCube is embedding a scheduler allowing for loading schemas using several trigger rules
(e.g., once, daily, fixed rates...).

For more control for loading and unloading schemas please refer to the
[REST API](../../api/requests.md#group--schema-management) section.

The scheduler UI is accessible from the monitoring WEB application
(tab schemas) and is pretty straightforward to use. As an example, the following picture is
showing a rule that loads the `Sales` schema every hour from 8am to 6pm.

![scheduler](img/schema_scheduler_large.png)

### Triggers

The trigger definitions are defining the execution (or 'firing') of load schema requests.
Several types of trigger are available: once, daily, cron, etc...

**Cron Trigger**

icCube is embedding the Quartz Scheduler trigger for its support of the Unix like cron scheduling capabilities.
You can refer to this [page](http://www.quartz-scheduler.org/documentation/quartz-2.3.0/tutorials/crontrigger.html)
for a detailed description of the cron format. In addition, you can search Google for more details
(and free online cron expression generator) as the icCube cron expression is following the Unix
cron format. See below several examples.

```
0 15 10 ? * *	         Fire at 10:15am every day

0 30 8,14 ? * MON-FRI    Fire at 8:30am and at 2.30pm every Monday, Tuesday, Wednesday, Thursday and Friday

0 30 8 1 1 ? 2050        Fire at 8.30am on Jan 1st, 2050
```

### Incremental Load & Continue On Error

Prior to icCube 8.4.14, any error during an incremental load is deactivating the incremental load of the schema
meaning there is no way to perform a new incremental load until a full reload has been performed. This is because
after this error, the schema is in an uncertain state. This means a repetitive schedule (e.g., daily) is going to
stop if the flag `Continue On Error` is not checked (default behavior).

Since icCube 8.4.14, such an error might not be _fatal_ anymore and can be recovered. Indeed, an incremental load
is performed using two steps :

- access the datasource and load all the new data from all the incremental tables,
- perform the actual incremental load of the schema using the loaded data.

Any error occurring in the first step will not be considered anymore as an error by the scheduler and the next
schedule will be executed and hopefully the data error will be fixed by then.

### Latest Run Request

The following picture is showing that the latest load-schema **request** when available is accessible from the rule
details panel. This is a hyperlink to the request monitoring panel where you can find more details about the processing
of the request.

![scheduler request](img/schema_scheduler_request_large.png)

### Load-On-Startup Flag

The `load-on-startup` flag as specified in the schema definition has become useless when using the scheduler.
It should not be used anymore to avoid any clash with a similar scheduling rule. Note that the same behavior
can be achieved with a `once` trigger having an initial delay of 0.

Next chapter: [Schema Alerts](schema_alerts.md) is giving an overview of the alerts feature.

_
