## Monitoring Counters

Monitoring counters allow for monitoring an icCube server instance. These counters lets you track CPU load,
memory usage, request activities, etc... Please refer to the following [page](../../mdx/icCubeCounters.md)
for the detailed list and description of available counters.

### Configuration

Activating and configuring is done via the icCube.xml configuration file; check the latest file
for up-to-date documentation:

```xml

<monitoringConfigurations>

    <!--
        Several <counters> elements might be defined...
    -->
    <counters>

        <!--
            Whether or not these monitoring counters are activated ( true | false )
        -->
        <activated>true</activated>

        <!--
            A comma separated string containing the list of counters to monitor; use '*' for all available.
        -->
        <counterFilter>*</counterFilter>

        <!--
            A comma separated list of names of the class managing the output (e.g. cube, logs, etc...).

            - crazydev.iccube.server.bigbrother.reporter.IcBigBrotherOlapCubeReporter  : [$Monitoring] schema
            - crazydev.iccube.server.bigbrother.reporter.IcBigBrotherReporter4J        : LOG4J

        -->
        <reporterClassNames>crazydev.iccube.server.bigbrother.reporter.IcBigBrotherOlapCubeReporter</reporterClassNames>

        <!--
            The initial delay in seconds before the monitoring of the counters is actually started.
        -->
        <initialMonitorBeansDelaySec>5</initialMonitorBeansDelaySec>

        <!--
            Frequency in seconds at which each counter value is collected.
        -->
        <monitorBeansEachSec>1</monitorBeansEachSec>

        <!--
            Frequency in seconds at which the system records the counter statistics.
        -->
        <reportingWindowSec>5</reportingWindowSec>

    </counters>

</monitoringConfigurations>
```

### Accessing the Counters : GetMonitoringCounter()

Each counter is accessible via the `GetMonitoringCounter` MDX function. You might refer to this
[page](../../mdx/GetMonitoringCounter.md) for more details and examples.

### Accessing the Counters : $Monitoring

Monitoring counters can be attached to different reporters. One of this reporter is an internal schema `[$Monitoring]`
that can be accessed (provided your role is giving access to the monitoring counters) as any other schema. The schema
is currently having time, counter and stats (e.g., min, max, avg ) dimensions. The `[Measures]` is containing all the
activated counters. To empty the schema, simply [unload](../../api/UnloadSchema.md) the schema `[$Monitoring]` and
it will be re-created at the beginning of the next reporting window.

Next chapter: [Commands](exec_commands.md) details several commands.

_
