### Facts Custom Aggregation (Beta)

Since icCube 9.x, you can define your own custom [aggregation](./facts_aggregation.md) (aka. **table aggregator**)
written in Java. With this, you are able to implement whatever logic is required and even implement an aggregation
for **non-additive** measures.

Please note this is still a **beta** feature and this is not integrated yet within the schema builder.
[Contact us](https://www.iccube.com/contact-us/) for more details about creating and using your own
aggregator right now.

### Overview

Have a look to this [blog](https://www.iccube.com/blog/mdx-meets-tabular) introducing this new type
of aggregation available in icCube. The article is showing several practical examples as well :

- **Weighted Averages** : Engine manages value × weight + weight internally → correct ratio every time.
- **FX Conversions** : Each row’s amount × daily FX rate applied at row level → accurate totals.
- **Time-Based Adjustments** : Multipliers applied per row → consistent results across time.
- **Property Management** : Delta-based storage becomes monthly values without memory bloat.

### Example

You can refer to this [blog](https://www.iccube.com/blog/retail-strategy-performantly-measuring-customer-diversity)
that explain how to implement efficiently an aggregation to compute the Shanon Entropy to improve retail strategy.

Next chapter: [Facts Many-2-Many (Bridges)](facts_many2many_bridges.md) shows how to create facts with
a many-to-many relation.

_
