## MultiLevel Hierarchy (Advanced)

Please refer to this [page](../../mdx_tutorial/dimensions.md) for a quick introduction of the dimension concept.

### Overview

In the previous chapter we defined a basic multi-level hierarchy. In this chapter we are going to introduce a more
complex example, adding multiple hierarchies.

Let´s start be explaining that facts are linked to a dimension. Each fact row is linked to a dimension through
the `default` (aka. `base`) hierarchy. All other hierarchies define a relationship to the base hierarchy members
and not directly to the facts. One member of a no `default` hierarchy is linked with a set of members of the
`default` hierarchy.

Another way to express this is by saying that the `default` hierarchy defines the dimension coordinates in the cube
(aka. facts). Other hierarchies represent different ways of grouping these coordinates, similar to a parent-child
relation. It should be clearer with an example. We are going to use a customer table with a list of attributes on
which we will define different hierarchies.

### Walkthrough

First, we need to define our data. For the sake of simplicity, we're going to use customer table with a few rows :

```
Customer, CuID , Continent , Country       , CoID, Language
Pierre  , 1    , Europe    , France        , FR  , French
Peter   , 2    , America   , United States , US  , English
Calen   , 3    , America   , Canada        , CA  , French
Jose    , 4    , America   , Mexico        , MX  , Spanish
```

```
CuID, Tokens
1   , 176
2   , 191
3   , 183
4   , 201
```

Each column of the customer table defines an attribute. 

Each attribute can be used to define a level within a hierarchy (e.g., `Country`). A hierarchy might contain 
ore or more levels (e.g., a `[Country]` hierarchy could be made of a `[Continent]` and `[Country]` levels).
Each level contains members (e.g., `[France]`, `[Spain]`, etc...) and are defined by their key and name.
If no key has been defined then the names are used as keys. Members can be ordered either by key or name.
Several constraints can be defined for both the keys and the names (e.g., unique).

We are free to combine these attributes to build new hierarchies. The constraint will be that our `default` 
hierarchy's last level will have to be the customer, as we have to link the dimension with the fact table using
the keys of the members of that last level.

For our example we're going to add three hierarchies : `[Customer]`, `[Country]`, `[Language]` : `[Customer]`
and `[Language]` being flat (one level) and `[Country]` with both `[Continent]` and `[Country]` levels.

After successfully deploying the schema, we would like to query the customer by country. A possible query
would be :

```
select
    [Measures].[Num. Tokens] on 0,
    [Customer].[Customer].members * [Customer].[Country].[Country].members on 1
from [Cube]
```

You can see from the result that non-existing tuples (e.g., `([Jose],[France])`) are automatically removed.
This is not due to the tuple being empty (no facts), it's due to the tuple not existing as per definition
of our dimension. This behavior is also called auto-exists. This is different to dimensions where we need
to perform a `NON EMPTY` to remove empty tuples. It's important to note that auto-exists is faster than
the nonempty version.

We could go one step further in the performance and pre-build a structure that mimics our request. In our
example it would entail creating a `[Country-Cust]` hierarchy with `[Country]` and `[Customer]` as levels.
Once created, and the schema deployed, we can rewrite our MDX query as :

```
select
    [Measures].[Num. Tokens] on 0,
    [Customer].[Country-Cust].members on 1
from [Cube]
```

The result is similar to the first one with a crossjoin. Furthermore, to get the customers for a country
we can perform a children MDX function on a country.

### Download

The schema of this example is available for download [here](data/Walkthrough_Multilevel_Advanced.zip).

Next chapter: [Dynamic Hierarchies](dim_dynamicHierarchies.md).

_
