## Functions (Plugins)

As part of a plugin, icCube allows you to add new functions which are then available from within MDX queries
as standard functions. For the sake of simplicity in their development, several kinds of user defined
functions are available.

### MDX Functions

```xml

<olapFunction
        className="crazydev.iccube.plugin.olapfunctions.OlapStrToHierarchyFunction"
        overwriteExisting="false"
/>
```

| Attribute           | Description                                                                                                                   |
|---------------------|-------------------------------------------------------------------------------------------------------------------------------|
| `className`         | The JAVA class declaring the function to add within the MDX engine. The new class must implement the class `OlapMdxFunction`. |
| `overwriteExisting` | Allows you to replace an existing MDX function with the same name.                                                            |

The source code of the JAVA `OlapStrToHierarchyFunction` class is available in the icCube plugin as explained
in the [examples](examples.md) chapter.

### MDX Statistical Functions

These functions allow you to implement statistics processing over a set of values.

```xml

<olapStatFunction
        mdxFunctionName="WAvg"
        mdxFunctionDescription="Calculate Weighted Average"
        className="crazydev.iccube.plugin.olapfunctions.stats.OlapWAvgFunction"
        overwriteExisting="false"
/>
```

| Attribute                | Description                                                                                                                                         |
|--------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------|
| `mdxFunctionName`        | The name (as used in MDX queries) of the function.                                                                                                  |
| `mdxFunctionDescription` | A short description of the purpose of the function.                                                                                                 |
| `className`              | The JAVA class declaring the function to add within the MDX engine; two base classes are available depending on the MDX signature of the functions. |
| `overwriteExisting`      | Allows you to replace an existing MDX function with the same name.                                                                                  |

Use the JAVA base class: `OlapPluginOneExprStatFunctions` for a function with the following signature:

`function( Set_Expression [, Numeric_Expression ] )`

Use the JAVA base class : `OlapPluginTwoExprStatFunctions`  for a function with the following signature:

`function( Set_Expression, Numeric_ExpressionX [, Numeric_ExpressionY ] )`

The source code of the JAVA `OlapWAvgFunction` class is available in the icCube plugin as explained in the
[examples](examples.md) chapter.

### JAVA Functions

This is a simple way to add funtions that are not based on MDX entities (e.g. members, dimensions, hierarchies,..)
They might take as parameter scalar values, and returning scalar values (e.g. cos(2.2), sin(3.7), etc.).

```xml

<javaFunctions
        moduleName="VBA"
        className="crazydev.iccube.plugin.olapfunctions.excel.OlapVBExcelNumericalFunctions"
        overwriteMain="false"
        overwriteModule="false"
/>
```

| Attribute         | Description                                                                                                                                                                    |
|-------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `moduleName`      | Defines the module name (sort of namespace) of the functions (e.g. the function `MID` defined within the `VBA` module may be referenced as `VBA!MID` from within MDX queries). |
| `className`       | The JAVA class declaring the functions to add within the MDX engine. New functions are declared as static fields implementing the class `OlapPluginUserJavaFunction`.          |
| `overwriteMain`   | Allows you to replace existing MDX functions with the same names (without the module name).                                                                                    |
| `overwriteModule` | Allows you to replace existing MDX functions with the same names (with the module name).                                                                                       |

The source code of the JAVA `OlapVBExcelNumericalFunctions` class is available in the icCube plugin as explained
in the [examples](examples.md) chapter.

Next chapter : [Configuration](configuration.md) shows how to configure plugins.

_
