## Migrating icCube : 8.6.1 to 8.6.2

The icCube 8.6.2 server is backward compatible with icCube 8.6.1. Please review the following points to ensure
your existing production environment can be properly migrated.

**IMPORTANT** : Support for facts pre-aggregation when building measure groups has been deprecated/removed.
Please contact us if you were using this feature.

**IMPORTANT** : Deprecated many-2-many facts has been removed. This can be replaced using bridges.
Please contact us if you were using this feature.

**IMPORTANT** : 'If Null/Empty Use' field in the columns of builder tables handle strings composed solely of
spaces as well. This might change your schema.

## On-The-Fly Authorization

The $$ processing (i.e., header replacement) in authorization script is case-insensitive.

The `Docs` part of the template role was ignored. Now the generated role definition is based on the `Docs`
as defined in the template role. Similarly to the `Schemas` part, $$ replacement is performed as well.

## Double Values Aggregation & Rounding Errors

8.6.2 has introduced the configuration `icCube.mdxSumAlgo` in the file `icCube.xml` to control how **double values**
are aggregated (aka. sum) to minimize rounding errors. When not defined, the `STANDARD` method is being used as before.
That is, all values are aggregated using the sum operator and no specific logic is being applied to minimize rounding
errors. In that case, you can use the new `Sum (high precision)` aggregation for new measures when required :
[aggregation type](user_guide/schemas_cubes/facts_aggregation.md).

New installation of icCube using the default `icCube.xml` file will use
the [NEUMAIER](https://en.wikipedia.org/wiki/Kahan_summation_algorithm)  summation minimizing rounding errors.
Apart possibly changing a bit the results (depending on the actual distribution of the double values being added),
this might impact any existing MDX expression like :

    IIF( [Measures].[Variance] = 0.0, ..., ... )

Indeed, the hypothetical `[Measures].[Variance]` value might not be exactly `0.0` anymore. But this way of
comparing a measure to 0 as a double value **was more likely wrong** in the first place because of rounding
errors. Such comparison should be better written like :

    IIF( abs( [Measures].[Variance] ) < 1e-10, ..., ... )

adjusting the comparison delta to whatever value is required by your business case.

There should be not significant **performance** impact regarding the processing of the MDX queries; however,
**we recommend verifying** this with your schema.

## Week Level Definition

The week definition depends on the **country** of the locale as defined in the time dimension (or hierarchy).
Note that using for example English (`en`) or French (`fr`) locale is not enough as they do not define any
country : use instead United States (`en_US`) or France (`fr_FR`) to ensure the weeks are properly defined.

When no locale is defined, icCube uses [ISO-8601 definition](https://en.wikipedia.org/wiki/ISO_week_date).

## Dimension / Cube Names

The name of a dimension cannot be used anymore as a cube name. Use the property `icCube.dimensionCubeNameUnique` 
in the file `icCube.xml` to revert to the old behavior.

## Reverse Index

The `Reverse Index` has been deprecated as it should not be required anymore. It was used for improving the speed
of large MDX crossjoin. Should you see any MDX performance regression, please contact us. 

## Table : Is Null/Empty Null

The table column `Is Null/Empty Use` behavior is taking into account strings containing only white spaces as well.
The option has been renamed into `Is Null/Blank Use`.

## Pivot Table Header Alignement

The behavior of the pivot Table header alignment on 'Left Header Alignment' &  'Header Alignment'
have changed to fix non-applied configuration (left or right). Please review carefully your dashboards
with pivot tables.

_