## Migrating icCube : 8.4.13 to 8.4.14

8.4.14 is a maintenance release of 8.4.13. If you're migrating from an earlier version please
**review carefully** the migration [document](8_3_0_to_8_4_0.md).

### Java 21 (LTS)

Since icCube v8.4.10, Java 21 (LTS) is being required to run icCube.

### Incremental Load on Error

Prior to icCube 8.4.14, any error during an incremental load is deactivating the incremental load of the schema
meaning there is no way to perform a new incremental load until a full reload has been performed. This is because
after this error, the schema is in an uncertain state.

Since icCube 8.4.14, such an error might not be _fatal_ anymore and can be recovered. Indeed, an incremental load
is performed using two steps :

- access the datasource and load all the new data from all the incremental tables,
- perform the actual incremental load of the schema using the loaded data.

Any error occurring in the first step will not be considered anymore as a _fatal_ error and a new incremental
load is still possible. Indeed, until the first step has been fully processed, the internal data of the schema
has not been updated at all.

**UI Schema Loaded Status**

The UI has been improved to display the `Incremental Load Status` : ok vs. deactivated.

**UI Load Schema Request**

The UI has been improved to display the `Incremental Load Status` : ok vs. deactivated.

**Backup**

With the backup mode activated, any incremental load is being saved into the backup. Any error occurring in
the first step of an incremental load will not stop the backup anymore. Indeed, this incremental load can be
safely ignored as it did not update anything in the schema.

**Scheduler**

Even if the flag `Continue On Error` is not checked (default behavior), any error occurring in the first step
of an incremental load will not be considered anymore as an error by the scheduler and the next schedule (e.g., 
daily schedule) will be executed and hopefully the data error will be fixed by then.

**REST API**

The response of the request `LoadSchema` (using the `incrLoad` parameter to perform an incremental load) is now
containing the `incrLoadStatus` field (`OK`, `DEACTIVATED`) to indicate if the incremental load has been deactivated
due to some unrecoverable error occurred in the second step.

_