## Physical Memory (RAM) Configuration

icCube being an in-memory multi-dimensional server, you must pay attention to the [configuration](jre_options.md)
of the amount of physical RAM allocated for the Java Virtual Machine (JVM). Please refer to
this [page](../../../devops/memory/MemoryJavaProcess.md)
for detailed information of the memory used by a Java process.

### Index / Facts Files

icCube allows for storing index and facts into files to minimize the actual amount of physical memory
required. This feature is available on both Windows and Linux. We highly recommend Linux where the I/O
are faster, steadier and do not suffer from files being locked.

### icCube.xml

Configuration properties are available the [icCube.xml](iccube_xml.md) file:
`icCube.factFileSize`, `icCube.indexFileSize,` etc... See comments in this file for detailed and
up-to-date explanations about their purposes and actual values.

### Schema Setup

This option is defined at schema level as an advanced property: `Storage Policy`. All measure groups
from the schema will store their index / facts according to this setting :

![facts on files](img/facts_files_large.png)

Storing the facts index in files might be interesting when you have a lot of dimensions and several
are of them are used rarely. In that case, no RAM will be used until you need them. Of course, the MDX 
processing will be slower as the OS has to fetch the required index from disk.

### Linux Configuration

`vm.max_map_count`

Index and facts are stored in files using memory mapped files. On Linux, there is a limit on
the number of memory mappings a process can have. Default configuration is typically as follows:

```
# sysctl vm.max_map_count
vm.max_map_count = 65530
```

Depending on the size and number of schemas in icCube, you might need to increase this value.
A high value (e.g., 655300) should have no impact on your system.

`fs.file-max`

You might need as well to increment the max number of open files. To display the current limit:

```
# sysctl fs.file-max
fs.file-max = 65535
```

### Use Case : Lots of Schemas

You have several schemas, each one fitting in RAM but the amount of physical RAM is not enough
to load all the schemas in RAM.

You can then set up several (or all) schemas to have their facts stored in files. Performance (that is MDX
query processing time) is then depending on how often each schema is being accessed by the MDX queries.
For example, if the same schemas are re-used very often, then they will be cached in RAM by the OS and
you should not see any performance issue compared to a full RAM configuration.

### Use Case : Large Schema

You have a large schema that does not fit in RAM.

Storing the facts into files will solve this issue. Performance (i.e., MDX query processing time)
is now depending on how many facts you are going to access as this might require accessing files.
But if the queries are accessing sub-cubes (e.g., drilldown, filtering, etc...), then it is more
likely that facts are going to be cached by the OS within the amount of physical RAM your system
has (the more, the better) and you should not see any performance issues compared to a full RAM
configuration.

_

