## Java Options

This page explains how to configure the Java Virtual Machine used by icCube as well as specifying
Java system properties (i.e., `-Dproperty=value`) on different OS. For more details about the RAM usage,
please read the following [page](ram.md).

### Available icCube Java System Properties

The variable `icCube.configuration.file` when defined, references the `icCube.xml` file to use instead of
the default one (`$install/bin/icCube.xml`).

The variable `icCube.log4j.configuration.file` when defined, references the `log4j.xml` file to use instead of
the default one (`$install/bin/log4j.xml`).

The variable `icCube.license.file` when defined, references the `icCube-4.lic` file to use instead of
the default one (`$install/bin/icCube-4.lic`).

### icCube.xml

A Java system property may be used to define a configuration.

For example, the following string :

    ${http.port:-8282}      or  ${sys:http.port:-8282} 

will be replaced by the value of the `http.port` variable or `8282` if the variable is not defined.

### Schema Definition

The XML definition of a schema can contain references to existing JAVA system properties that will be replaced
at runtime by their actual values. For example, the following string :

```
${sys:JDBC_SERVER:-localhost}
```

will be replaced by the value of the `JDBC_SERVER` property or `localhost` if the property is not defined.

See the following documentation for more details about different parts of the schema definition:

- [JDBC datasource](../schemas_cubes/ds_database.md)

### Windows Configuration

On Windows, the `icCube.bat` content is similar to the one used on Unix as described below.

### Mac OS Configuration

Edit the file `Info.plist` of the application bundle icCube.app as follows:

```
<key>Java</key>
    <dict>
        <key>VMOptions</key><string>-Xmx768M</string>
```

### Unix Configuration

On Unix, the shell script `$install/bin/icCube.sh` is used to start the icCube server. This is the place
to specify your `JAVA_OPTS` variable:

```shell
JAVA_OPTS="-Xmx768M ..."
```

Next chapter : [Authentication](authentication_overview.md) describes how to configure user's authentication.

_
