## Multiple Linear Regression

### Definition

**MultiLinearRegression**(*[Additional Parameters]*, *[Highest Correlation]*, *[Threshold]*)

| parameter             | type    | default | description                                                                          |
|:----------------------|:--------|---------|:-------------------------------------------------------------------------------------|
| Additional Parameters | boolean | false   | Adds rows with parameters as R Squared, Adjusted R Square...                         |                 
| Highest Correlation   | boolean | false   | Adds a column with the highest correlation between the variables, max( Corr(v1,vj) ) |
| Tolerance             | numeric | 1e-7    | Defines the singularity tolerance/threshold for the QR decomposition.                |                   

### Description

The [multiple linear regression](https://en.wikipedia.org/wiki/Linear_regression) is a statistical method used to
estimate the (linear) relationship or dependency between an $\text{$n$-vector}$ $Y$
and independent variables $X_1,...,X_n$, also called regressors. In other words, it is used to test if $Y$ can be
explained by a linear combination of $X_i$ with $i = 1, \ldots , n$:

$$Y \sim \alpha_1X_1 + \alpha_2X_2 + \ldots + \alpha_nX_n + u$$

where

$$
Y = \begin{pmatrix}\\
y_1 \\
\vdots\\
y_n\\
\end{pmatrix},\\
\space\\
X_i = \begin{pmatrix}\\
x_{i1} \\
\vdots\\
x_{ip}\\
\end{pmatrix},\\
\space\\
i = 1, \ldots , n\\
$$

and

$$
u = \begin{pmatrix}\\
u_1 \\
\vdots\\
u_n\\
\end{pmatrix}\\
$$
is the error vector or residuals.

The aim is therefore to estimate the $\alpha_i$, $i = 1, \ldots, n$ and minimize $u$. The multiple linear regression
calculation can be achieved with the following MDX post-processing:

```
SELECT
   {[Measures].[Y], [Measures].[X1], [Measures].[X2], [Measures].[X3]} on 0
   [Observation].[Observation].[Observation] on 1
FROM [Cube]
   
TIDYPOSTPROCESSOR  MultiLinearRegression()
```

This produces the following tidy table:

| label<br><span style="font-weight:normal;color:gray">&lt;Character&gt;</span> | value<br><span style="font-weight:normal;color:gray">&lt;Numeric&gt;</span> | pValues<br><span style="font-weight:normal;color:gray">&lt;Numeric&gt;</span> |
|:------------------------------------------------------------------------------|:----------------------------------------------------------------------------|:------------------------------------------------------------------------------|
| $u$                                                                           | 7.2026                                                                      | 0.33                                                                          |
| $\alpha_1$                                                                    | 4.7257                                                                      | 0.14                                                                          |
| $\alpha_2$                                                                    | 2.3358                                                                      | 0.25                                                                          |
| $\alpha_3$                                                                    | 0.7825                                                                      | 0.01                                                                          |

With the *value column* the estimated regression parameters and the *pValues column* the p-values of multiple linear
regression analysis

### Parameters

#### Aditional Parameters

To get more statistical parameters, set the multilinear regression function argument to `true`:

```
TIDYPOSTPROCESSOR  MultiLinearRegression(true)
```

This will therefore produces the tidy table:

| label<br><span style="font-weight:normal;color:gray">&lt;Character&gt;</span> | value<br><span style="font-weight:normal;color:gray">&lt;Numeric&gt;</span> | pValues<br><span style="font-weight:normal;color:gray">&lt;Numeric&gt;</span> |
|:------------------------------------------------------------------------------|:----------------------------------------------------------------------------|:------------------------------------------------------------------------------|
| $u$                                                                           | 7.2026                                                                      | 0.33                                                                          |
| $\alpha_1$                                                                    | 4.7257                                                                      | 0.14                                                                          |
| $\alpha_2$                                                                    | 2.3358                                                                      | 0.25                                                                          |
| $\alpha_3$                                                                    | 0.7825                                                                      | 0.01                                                                          |
| R Squared                                                                     | 0.9250                                                                      |
| Adjusted R Squared                                                            | 0.8937                                                                      |
| Total Sum Of Squares                                                          | 1222.9444                                                                   |
| Residual Sum Of Squares                                                       | 91.6788                                                                     |

#### Tolerance

The multiple linear regression uses a QR Decomposition that can lead to a singular matrix if there is no solution. For
example if two variables are perfectly correlated.

Note, a tolerance/threshold of 0.0 will unlikely throw a Singular Matrix error but will return wrong results.

_
