## Dimension Properties (Post Processing)

This result post processor allows for adding member [properties](../mdx/Member%20Custom%20Property.md) as columns
of the result of your MDX queries for the widgets in the Dashboards application and MDX IDE. For example, in the
following table the `Country` has been retrieved as a property of the `City` members without having to write
a crossjoin :

| Country | City      | Population |
|---------|-----------|-----------:|
| France  | Paris     | 10 944 094 |
| France  | Lyon      |    520 774 |
| Spain   | Madrid    |  3 416 771 |
| Spain   | Barcelona |  1 702 547 |

Note that in the Dashboards application, you could retrieve those properties using the
[DIMENSION PROPERTIES](../mdx/Dimension%20Properties.md) clause. The properties would then be displayed as tooltip
of the members. You would have to use several result transformations to display them as columns. Plus, you would have
to write your own MDX query as the graphical query builder does not support the `DIMENSION PROPERTIES` clause.

### Syntax

The tidy [post processor](index.md) is called `DimensionProperties` and accept a list of properties with their
expected positions in the MDX axes :

    TIDYPOSTPROCESSOR DimensionProperties(
      _( [hierarchy-unique-name].[property-name], axis-number, axis-position ),
      _( [hierarchy-unique-name].[property-name], axis-number, axis-position ),
      ...
    )

If you do not need to give the positions of the added columns, an alternate and simpler syntax is available.
In that case, the new columns will be placed right after the corresponding member's column :

    TIDYPOSTPROCESSOR DimensionProperties(
      [hierarchy-unique-name].[property-name],
      [hierarchy-unique-name].[property-name],
      ...
    )

The retrieval logic of the properties is based on the logic of the `GetProperty` MDX function. It can retrieve
both the [properties](../mdx/Member%20Custom%20Property.md) and the [attributes](../mdx/Member%20Attributes.md)
of the members.

### Example

The following is retrieving 4 properties of the `Item` members and creating accordingly the 4 columns in the result
table. Notice how the columns are placed in the result according to the configuration of the post processor :

    select

      { [Measures].[Sales], [Measures].[#Units] } on 0

      non empty [Calendar].[Year] * [Item].[Item].[Item] on 1
  
      from [Sales]

    TidyPostProcessor DimensionProperties(
       _( [Item].[Item].[Department], 1, 1 ),
       _( [Item].[Item].[Brand], 1, 2 ),
       _( [Item].[Item].[SKU], 1, 4 ),
    )

| Year | Department | Brand  | Item      | SKU         |   Sales | #Units |
|------|------------|--------|-----------|-------------|--------:|-------:|
| 2025 | Cars       | Toyota | CHR       | TOY-CHR-STD | 553 000 |     10 | 
| 2025 | Cars       | Audi   | Q6 e-tron | AUD-Q6E-VIP | 956 000 |     12 | 
| ...  | ...        | ...    | ...       | ...         |     ... |    ... | 

### Native Integration into the Graphical Query Builder

In the Dashboards application, the graphical query builder is dropping the properties into the tidy post processor.
The following picture is showing how both the `Continent` and the `Country` properties are added before the  `City`
members on the `Rows` axis :

![Properties](img/properties.png)

### Versus DIMENSION PROPERTIES Clause

The `DimensionProperties` post processor is similar to the [DIMENSION PROPERTIES](../mdx/Dimension%20Properties.md)
clause but not equivalent. Indeed, the post processor is using the same retrieval logic as the `GetProperty` function.
That is, the properties of the parent members are also accessible from their children. On top, the post processor is
retrieving the properties based on their hierarchy and not their level only.

### Versus a GetProperty() Measure

The above example could have been written using calculated measures and the `GetPropery` function. However, this
approach is having a major drawback as it breaks the `non empty` behavior on the axis 1. Indeed, this behavior
should be based on the emptiness of both the `[Sales]` and the `[#Units]` measures and not the `Department`,
`Brand` and `SKU` that are only values derived for the actual selected **non-empty** Item members.

    with 
      Department as [Item].[Item].currentMember.getProperty( "Department" )
      Brand      as [Item].[Item].currentMember.getProperty( "Brand" )
      SKU        as [Item].[Item].currentMember.getProperty( "SKU" )

    select
     
      { Department, Brand, SKU, [Measures].[Sales], [Measures].[#Units] } on 0
     
      non empty [Calendar].[Year] * [Item].[Item].[Item] on 1
  
      from [Sales]

On top, this calculated measures approach does not allow to add the property columns right within the members
columns. For that purpose, you would have to use result transformations in the Dashboards application.

### Versus Members Crossjoin

You might be wondering why this post processor is being compared to members crossjoins. Actually, those crossjoins
are the main reason this tidy process processor has been introduced in icCube 9.0.0. Indeed, we have noticed that
a lot of people were generating this kind of MDX queries (see below, using again our previous example) to retrieve
actual properties/attributes of the selected members :

    select

      { [Measures].[Sales], [Measures].[#Units] } on 0

      non empty [Calendar].[Year]
        * [Item].[Department].[Department]
        * [Item].[Brand].[Brand]
        * [Item].[Item].[Item] 
        * [Item].[SKU].[SKU]

        on 1
  
      from [Sales]

Editing manually the same MDX to use `DIMENSION PROPERTIES` and adding result transformations is most of the time
not an option. Although this approach works perfectly, its main drawback is **performance** as the crossjoin can
quickly become very large and therefore time-consuming to process. The `DimensionProperties` post processor
therefore becomes the advised approach for cases like these.

### Limitations

As of icCube 9.0, the generated columns are not actual members columns - like the crossjoin approach mentioned above -
meaning they cannot be selected to generate events in the Dashboards application and drilldowns are not available yet.
But stay tuned as we'll improve this feature based on customers' feedback.

_
