## SELECT Statement

The SELECT statement/expression is the MDX way of querying multi-dimensional data, as described previously.
One of its simplest forms could be as follows:

    SELECT
        [Measures].Members ON COLUMNS,
        [Geography].[Geo].Members ON ROWS
    FROM
        [Sales]

Let's dissect this query in order to understand it better.

The `SELECT` keyword marks the beginning of the query. It specifies what you want to select.

The `ON` keyword is used to organize the selected data. MDX utilizes the concept of axes. The data selected from
a dimension can be put on an axis. In the query above, we selected the members of the `[Measure]` dimension and
put them on axis 0, or `COLUMNS`. And we selected the members of the `[Geography]` dimension and put them on axis 1,
or `ROWS`. However, a `SELECT` is not limited to two axes. We could have columns, rows, pages, chapters, and sections.
And you could still continue beyond these by specifying a number for the axis.

Note: A query that uses axis 1 must also use axis 0. A query that uses axis 2 must also use axis 1 and axis 0.
You cannot skip an axis in a query.

In the `FROM` clause, we specify the cube which will be used for querying the data specified in the `SELECT` clause.

You may have a question regarding tuples when you read the query above. We have explained that a tuple is a list
of hierarchy members taken from *every* dimension. However, in the query above, we are using members only from
`[Geography].[Geo]` and `[Time].[Calendar].[Year]`. Shouldn't we take members from all the dimensions to create
the tuple? The answer is that MDX uses the concept of a `default member`. Each hierarchy has a default member.
This is usually the top of the hierarchy. If a member from a dimension is not specified, then the default member
is automatically taken.

Just to elaborate some more on the concept of default members, the query below does not specify any member of any
hierarchy and yet it is a perfectly valid MDX query. It will return the default `[Measures]` value indexed by the
default members from all the other hierarchies:

    SELECT FROM [Sales]

## Next Step

[WHERE clause (aka. slicer)](where_clause.md).

_
