## FROM as a Slicer

Besides the `WHERE` clause, MDX provides a second method of slicing the cube. This is the `FROM` clause.
And the `FROM` clause is not limited only to a cube. A `SELECT` (a.k.a. sub-select, sub-query) can be used instead:

    SELECT
        [Measures].Members ON 0,
        [Geography].[Geo].Members ON 1
    FROM
        (SELECT [Time].[Calendar].[Year].[2010] ON 0 FROM [Sales])

This is equivalent to the previous query slicing the results for the `[Year].[2010]`. Sub-selects/queries allow
you to filter the dimensions (and the facts) of the cube to be queried.

To get more details about sub-queries, several illustrated working examples are available
from our MDX documentation pages [here](../mdx/SubQueries.md).

## Next Step

The next section is explaining how to [navigate](navigating_hierarchy.md) the hierarchies in a query.

_
