## MDX FAQ : How to sum of sum through a list of members?

In the following MDX statements, we calculate the `[YTD Customers Sales]` measure for a specific list of 
`[Customer]` members as follows :  

    set [YTD Dates] AS dtDatesYTD( lookupByKey([Calendar].[Calendar].[Day], now() ))

    set [Associated Customers] AS except( 
        [Customer].[Customer].[Customer].allMembers, 
        [Customer].[Customer].[Customer].[Unknown]
    )
        
    member [Measures].[YTD Customers Sales] as sum( 
        [Associated Customers], 
        sum(
            [YTD Dates], 
            [Measures].[Sales] 
        )
    )
)

While this expression works as expected, it becomes inefficient as the list of `[Customer]` members grows 
and the `[YTD Dates]` set expands. A more efficient version can be written as follows :

    set [YTD Dates] AS dtDatesYTD( lookupByKey([Calendar].[Calendar].[Day], now() ))

    member [Measures].[YTD Customers Sales] as eval(
        subCubeIntersect(
            subCubeComplement ( [Customer].[Customer].[Customer].[Unknown] ),
            subCubeUnion( [YTD Dates] )
        ),
        [Measures].[Sales]
    )
    
As shown, the new version leverages `subCube` functions with the [eval](../mdx/Eval.md) function. The `subCube` 
functions enable filtering of facts using various set operations :

    subCubeIntersect(
        subCubeComplement ( [Customer].[Customer].[Customer].[Unknown] ),
        subCubeUnion( [YTD Dates] )
    )

This optimized MDX version delivers better performance by removing the explicit double iteration.

## See Also

- [MDX FAQ](mdx_faq.md)

_