## MDX FAQ : How to calculate median?

If you're looking for a way to calculate the median of a measure over a set of members in MDX, the standard
MDX [function](../mdx/Median.md) is probably what brought you here. However, this method is generally inefficient
and becomes impractical when working with multiple dimensions.

As a reminder, the median is not an additive measure, which means it cannot be properly aggregated across multiple
dimensions by the OLAP engine.

Fortunately, icCube provides a much faster and more efficient way to calculate the median using vector aggregation.

We’ll demonstrate this using a model built from temperature observations collected over years at weather stations.

The idea is to create a new measure based on the existing measure `[Measures].[Temperature]`, but replace its average
aggregation with a vector aggregation. This vector aggregation is going to preserve the full series of temperature
observations recorded at each weather station over time :

    with measure [T_vector] as [Measures].[Temperature], AGGREGATION = AGGR_VECTOR

With the vector aggregation in place, we can now create a new calculated measure that computes the median value
of the temperature distribution :

    with measure [Temperature (median)] as [T_vector]->median()

Finally, this new median measure can be used like any standard measure in your queries. The median is computed
efficiently across all dimensions directly from the underlying fact rows, leveraging the vector aggregation 
for accuracy and performance.

For example, the following query compares the true median temperature with the average temperatures for each year
(aggregated across available weather stations) :

    with
        measure [T_vector] as [Measures].[Temperature], AGGREGATION = AGGR_VECTOR
        measure [Temperature (median)] as [T_median]->median()

    select
        { [Measures].[Temperature (median)], [Measures].[Temperature] } on 0
        [Time].[Time].[Year] on 1

    from [Observations]

This kind of query clearly shows how the median can differ from the average — especially useful when temperature
distributions are skewed or contain outliers (e.g., extreme weather events).

## See Also

- [MDX FAQ](mdx_faq.md)

_