## Offlines

Retrieves the list of schema offlines (aka. snapshots).

### URL

    /icCube/api/console/admin/Offlines

### Parameters

| Name   | Type     | Cardinality | Default Value |
|--------|----------|-------------|---------------|
| filter | `string` | zero-n      |               |

### Return (Payload)

    "header": {
        "headers": [
            "group", "schema",  "timestamp", "name" 
        ]
    },
    "rows": [
        { "cells": [ "Demo", "Sales", "12 Jul 2018 08:03:30", "Sales.icc-schema.2018_07_12_08h03m30.1531375410610" ] },
        { "cells": [ ...                                                                                           ] }
    ]

### Description

This request retrieves the list of schema offlines (aka. snapshots) in the icCube server. The `group` and `schema`
and `name` headers of the response payload can be used in the [filter](./request_format.md#filter) request.

### See Also

* [OfflineInfo](OfflineInfo.md)
* [Backups](Backups.md)
* [LoadedSchemas](LoadedSchemas.md)

_