## LoadSchema

Load a schema.

### URL

    /icCube/api/console/admin/LoadSchema

### Parameters

| Name               | Type      | Cardinality | Default Value |
|--------------------|-----------|-------------|---------------|
| filter             | `string`  | zero-n      |               |
| schemaName         | `string`  | zero-one    |               |
| schemaFile         | `string`  | zero-one    |               |
| incrLoad           | `boolean` | zero-one    |               |
| keepMdxResultCache | `boolean` | zero-one    |               |
| forceBackup        | `boolean` | zero-one    |               |
| timeoutS           | `number`  | zero-one    |               |
| waitS              | `number`  | zero-one    |               |
| cancelS            | `number`  | zero-one    |               |

### Return (Payload)

    {
        "schemaName"     : "Sales",
        "status"         : "LOADED"
        "incrLoadStatus" : "OK" | "DEACTIVATED"    -- relevant w/ param. incrLoad=true
        "info"           : "..."
        "errors"         : "..."
    }

### Description

This request performs a (re)load of a schema.

On completion, the response contains the status of the operation. Refer to this [page](schema_lifecycle_status.md)
for more details about it.

If the load schema has created a backup, the info field is containing the timestamp of the backup.

On completion on error, the errors filed might contain an array of errors (as free text).

When using the `schemaName` parameter, icCube is possibly scanning the content of the `/cubes` directory
(i.e., the deployed schemas) to locate the XML definition file (`.icc-schema` file) containing the schema
whose name is given by the request.

If the name of the schema definition file does not follow the icCube format (i.e., derived from the schema
name) and having a very large number of schema definition files, it is recommended to use instead the
`schemaFile` parameter.

Use the `incrLoad` parameter to perform an incremental load of the schema. The response is containing the
`incrLoadStatus` field (`OK`, `DEACTIVATED`) to indicate if the incremental load has been deactivated due 
to some unrecoverable error (i.e., the schema is an inconsistent state and should be fully reloaded).

Use the `keepMdxResultCache` parameter to restore the MDX result cache once the incremental
load has been performed if required. That is, existing cached requests are re-executed and cached.

Use the `forceBackup` parameter to force the backup generation even if the schema definition does not
mention it. Once loaded, the schema will continue to back up any subsequent activity (e.g., incremental load).
Relevant for full load only.

The optional `timeoutS` allows for defining a maximum elapsed time (in seconds) after which the load of the schema
is cancelled and the completion status of the request is error with the `payload.code = UX_TIMEOUT`.

The optional `waitS` and `cancelS` parameters allows for cancelling ongoing requests. A lengthy request might prevent
the actual load (e.g. incremental load, reload, etc..) of the schema. Unless specified otherwise loading a schema
(or partitions) is performed in two steps. The first step is loading the required data and the second step is actually
updating the already loaded schema. The first step can be performed in parallel of ongoing MDX requests but the second
step requires no more requests are accessing the schema. Therefore, the load is stuck until all requests are completed.
These two parameters allows for cancelling the requests before the second step is performed. Before the second step,
icCube waits for `waitS` seconds, then if it cancels the ongoing requests (if any) and waits for `cancelS` seconds.
Then if there is still some ongoing requests the load fails otherwise icCube proceed with the second step.

### See Also

* [UnloadSchema](UnloadSchema.md)
* [SchemaInfo](SchemaInfo.md)
* [SchemaFile](SchemaFile.md)

_