## On-The-Fly Authorization: Schemas

This section is assuming a general understanding of the on-the-fly authorization mechanism. Please refer to this
[page](../OnTheFlyAuthorization.md) for a general presentation.

### Overview

This page describes how to define the content of the `Schemas` part of the role of the user being connected to icCube:

![Role Definition Schemas](./images/role-definition-schemas.png)

This `Schemas` part contains the permissions granting access to data from the schema level down to a (cube) cell level.
Please refer to this [page](../../server/user_guide/security/schema_permissions.md) for a detailed explanation of the
syntax of the language being used.

The following sections describe **three different ways** to define those permissions.

### 1 - Schema Names

The `schemas` HTTP header defines the list of schemas the user has access to. It is defined as a
comma separated list of names.

The default name of the HTTP header is: `ic3-Schemas`. This name can be changed with the following parameter
of the `IcCubeHeaderAuthenticationService` section (`icCube.xml`):

```xml

<param>
    <name>header.schemas</name>
    <value>IC3_SCHEMAS</value>
</param>
```

### 2 - Schemas Permissions

The `schemas-perms` HTTP header fully defines the `Schemas` part of the role.

Note that an **empty** profile is granting full access to all the schemas. Use the following profile to deny access
to all schemas:

```
-schemas
```

Note that when defining this profile via an HTTP header, you have to merge all the lines together
and separate them with a comma (the header cannot be multi-line). So for example, the following header:

```
+schemaAccess R,-schema [Sales]
```

is actually defining the following profile:

```
+schemaAccess R
-schema [Sales]
```

Should you need to use a `,` within your definition, you'll have to **escape** it by doubling it.

The default name of the HTTP header is: `ic3-Schemas-Perms`. This name can be changed with the following parameter
of the `IcCubeHeaderAuthenticationService` section (`icCube.xml`):

```xml

<param>
    <name>header.schemas.perms</name>
    <value>IC3_SCHEMAS_PERMS</value>
</param>
```

### 3 - Search & Replace Pattern

Eventually, if the `Schemas` definition of the template role ([www](../OnTheFlyAuthorization.md#role)) contains
`$$...$$` strings then every matching header will be replaced in this definition as following:

```
foreach( header in headers ) {
   schemas = schemas.replace( $$header.name$$ , header.value )
}
```

So for example, let's say the definition is as following:

```
+schema [$$IC3_SCHEMA_NAME$$]

:schema[$$IC3_SCHEMA_NAME$$]
+tuples DC [Country].[Country].[Country].&[$$IC3_COUNTRY$$]
```

And the HTTP request contains the following HTTP headers:

```
IC3_SCHEMA_NAME : Sales
IC3_COUNTRY     : France
```

Then the generated `Schemas` definition would be:

```
+schema [Sales]

:schema[Sales]
+tuples DC [Country].[Country].[Country].&[France]
```

_