## On-The-Fly Authorization: Dashboards Denied Features

This section is assuming a general understanding of the on-the-fly authorization mechanism. Please refer to this
[page](../OnTheFlyAuthorization.md) for a general presentation.

### HTTP Header

The `dashboards` HTTP header defines the content of the `Dashboards (Denied Features)` part of the role of the
user being connected to icCube:

![Role Definition Dashboards](./images/role-definition-dashboards.png)

This HTTP header contains the actual list of denied features of the `Dashboards` application. Please refer
to this [page](../../server/user_guide/security/dashboards_permissions.md) for a detailed list of the features.

### New Lines

Note that when defining those permissions via an HTTP header, you have to merge all the lines together
and separate them with a comma (the header cannot be multi-line). So for example, the following header:

```
-- Self-BI Users cannot create new dashboard neither add widget to existing ones.,EditorNewDashboard,EditorNewWidget
```

is actually defining the following permissions:

```
-- Self-BI Users cannot create new dashboard neither add widget to existing ones.
EditorNewDashboard
EditorNewWidget
```

### Configuration

The default name of the HTTP header is: `ic3-Dashboards`. This name can be changed with the following parameter
of the `IcCubeHeaderAuthenticationService` section (`icCube.xml`):

```xml

<param>
    <name>header.dashboards</name>
    <value>IC3_DASHBOARDS</value>
</param>
```

_