## Java Garbage Collector

This document is assuming the reader is familiar with icCube as a Java process and its [memory](MemoryJavaProcess.md) 
usage.

### Overview

Please refer to this [page](https://www.baeldung.com/jvm-garbage-collectors) for a brief
overview of the different garbage collectors available in Java.

For your information, as of September 2023 (and icCube 8.4.4), icCube Dockers container and Windows kit are using 
Java 17 and its default garbage collector : G1.

### Pauses

Pauses are a side effect of garbage collectors reclaiming memory : the pause time is the duration during which
the garbage collector **stops the application** to reclaim memory.

Unless badly configured, a small Java heap should not trigger long pauses.

A quick way to monitor garbage collections (aka. GC later in this document) is to do a `grep` in the icCube log files, 
which will show the following :

```
    # zgrep "\[GC\]" icCube.log*

    ... (12-09-23 11:34:43.243 UTC) [GC] (G1 Young Generation) : 40ms ( free:717MB / total:1736MB / max:3072MB )
    ... (12-09-23 11:47:42.837 UTC) [GC] (G1 Young Generation) : 42ms ( free:726MB / total:1736MB / max:3072MB )
    ... (12-09-23 11:48:00.461 UTC) [GC] (G1 Young Generation) : 25ms ( free:728MB / total:1736MB / max:3072MB )
    ... (12-09-23 12:19:16.977 UTC) [GC] (G1 Young Generation) : 86ms ( free:712MB / total:1736MB / max:3072MB )
    ... (12-09-23 12:40:58.467 UTC) [GC] (G1 Young Generation) : 69ms ( free:657MB / total:1736MB / max:3072MB )
```

The above extract is showing the pauses are very small (e.g., 40ms, 42ms, etc...) so nothing is wrong.

In case pauses seem excessively long, do not hesitate to [contact us](https://www.iccube.com/contact-us/).

### Manual Garbage Collection 

Although this is not recommended (and useful) to explicit run a garbage collection it might be handy when 
troubleshooting the memory usage.

The `Server Status` is showing a `Perform GC` action in the top right 3-dots icon : 

![GC](images/gc.png)

Note that the REST [API](../../server/api/PerformGc.md) allows for performing this action. Alternatively, 
the `jcmd` command can be used as well :

```
    # jcmd PID GC.run
```

### See Also

Please refer to this [page](../MemoryUsage.md) for a series of documents related to the memory usage in icCube.

### Contact Us

Do not hesitate to [contact us](https://www.iccube.com/contact-us/) for some help configuring the memory.

_