## Docker Container Memory Usage

Dockerhub is hosting the official icCube container [image](https://hub.docker.com/r/ic3software/iccube). This
section is describing the runtime of icCube as hosted in a Docker container regarding its memory usage. This
document is assuming the reader is familiar with icCube as a Java process and its [memory](MemoryJavaProcess.md)
usage.

### Unexpected Restart

From time to time, our customers are contacting the support service because of unexpected container restarts.
This document is giving some advices for troubleshooting this situation.

In the `Dockerfile` the icCube Java process is started as following :

    CMD exec /opt/icCube/bin/icCube.sh

with the `icCube.sh` eventually calling :

    exec $JAVA $ICCUBE_JAVA_OPTS $ICCUBE_JAVA_OPTS_EX -cp "$ICCUBE/lib/*" crazydev.iccube.server.IcCubeServer

meaning that the `java` process will be the root process (i.e., `PID=1`). An unexpected stop of this process
will stop the container and possibly trigger a restart. One possible unexpected stop of this process might be
related to a badly configured icCube server regarding its [memory](MemoryJavaProcess.md).

Note that **printing dashboards** is performed using Chrome|Chromium in headless mode that will require
some memory as well. You can refer to this [section](#chrome-headless-printing) at the end of this document
for more information. 

### Memory Usage Monitoring

Let's start a container with `1g` of memory and `no swap` (for the sake of simplicity) and a Java heap of `512m` :

    sudo docker run -d \
        --name ic3 \
        --memory 1g --memory-swap 1g \ 
        -e ICCUBE_JAVA_OPTS="-Xmx512m -XX:NativeMemoryTracking=summary" \
        -p 8282:8282  \
        ic3software/iccube:8.4.6

Notice the usage of `-XX:NativeMemoryTracking=summary` for activating
[Native Memory Tracking](https://docs.oracle.com/javase/8/docs/technotes/guides/troubleshoot/tooldescr007.html)
(aka. NMT later in this document).

This example is using quite a small amount of RAM available to explicitly show the difference between the expected
heap size and the actual process memory usage. You can check the following [section](#native-memory-overhead) for
some more details about the difference/overhead for larger heaps.

In the host, after using icCube for a while, the following command :

     sudo docker stats

is showing the actual `MEM USAGE` compared to the `LIMIT`  :

    CONTAINER ID   NAME      CPU %     MEM USAGE / LIMIT   MEM %     NET I/O          BLOCK I/O       PIDS
    f8c08571e3ad   ic3       0.25%     856MiB / 1GiB       83.59%    156kB / 3.54MB   174MB / 110MB   56

Similarly, attaching a shell to the Docker and running `top` is showing the `RES` memory :

    # sudo docker exec -it ic3 /bin/bash
    # top

    PID USER      PR  NI    VIRT    RES    SHR S  %CPU  %MEM     TIME+ COMMAND                                                                                                                       
      1 ic3       20   0 6188404 847044  37836 S   0.3   1.3   0:24.21 java                                                                                                                          

So, the Java process is using around `850m` of RAM (this includes both the Java heap and its native memory).

To confirm that, let's have a look to this native memory using NMT :

    # sudo docker exec -it ic3 /bin/bash
    # jcmd 1  VM.native_memory summary scale=MB

    Total: reserved=1956MB, committed=670MB
    -                 Java Heap (reserved=512MB, committed=512MB)
                                (mmap: reserved=512MB, committed=512MB) 
    
    -                     Class (reserved=1025MB, committed=10MB)
                                (classes #13509)
                                (  instance classes #12628, array classes #881)
                                (malloc=1MB #31083) 
                                (mmap: reserved=1024MB, committed=9MB) 
                                (  Metadata:   )
                                (    reserved=64MB, committed=63MB)
                                (    used=62MB)
                                (    waste=1MB =1.41%)
                                (  Class space:)
                                (    reserved=1024MB, committed=9MB)
                                (    used=8MB)
                                (    waste=1MB =6.59%)
    
    -                    Thread (reserved=56MB, committed=6MB)
                                (thread #57)
                                (stack: reserved=56MB, committed=6MB)
    
    -                      Code (reserved=244MB, committed=29MB)
                                (malloc=2MB #10206) 
                                (mmap: reserved=242MB, committed=27MB) 
    
    -                        GC (reserved=2MB, committed=2MB)
                                (mmap: reserved=2MB, committed=2MB) 
    
    -                  Compiler (reserved=1MB, committed=1MB)
    
    -                     Other (reserved=1MB, committed=1MB)
                                (malloc=1MB #61) 
    
    -                    Symbol (reserved=21MB, committed=21MB)
                                (malloc=20MB #674784) 
                                (arena=1MB #1)
    
    -    Native Memory Tracking (reserved=11MB, committed=11MB)
         (tracking overhead=11MB)
    
    -        Shared class space (reserved=16MB, committed=12MB)
                                (mmap: reserved=16MB, committed=12MB) 
    
    -               Arena Chunk (reserved=2MB, committed=2MB)
                                (malloc=2MB) 
    
    -                 Metaspace (reserved=64MB, committed=63MB)
                                (mmap: reserved=64MB, committed=63MB) 

The `reserved` memory represents the total amount of memory the Java process can potentially use. Conversely,
the `committed` memory is equal to the amount of memory the Java process is using right now :

    Total: reserved=1956MB, committed=670MB

Obviously, NMT is showing that the JVM can potentially use much more than the `1g` limit for our Docker. A quick
thing to notice as well is that the `670m` of committed memory is below the actual `850m` of `RSS` memory  as reported
by `docker stats, top, etc...`. 

The following Stackoverflow questions can give you some details insights about the reasons :

- [Native memory consumed by JVM vs java process total memory usage](https://stackoverflow.com/questions/62635023/native-memory-consumed-by-jvm-vs-java-process-total-memory-usage)
- [Java using much more memory than heap size (or size correctly Docker memory limit)](https://stackoverflow.com/questions/53451103/java-using-much-more-memory-than-heap-size-or-size-correctly-docker-memory-limi/53624438#53624438)

As there is no magic formula giving the exact value of the `-Xmx` parameter and the actual limit of the Docker
container please refer to this [section](MemoryJavaProcess.md#heap--how-to-determine-the-maximum-value---xmx--)
for several advices about configuring icCube memory (e.g., **stress testing in a staging environment**). 

From the stress testing explained in the previous section, you will be able to determine the upper value of the
`committed` memory and you will notice than the `reserved` memory is still higher that the available memory. It is 
more likely that this JVM estimation is way **too high** for your current usage of icCube. If you are unable to allocate
additional RAM to the container we recommend using some **swap** space as a precautionary measure to prevent any 
unexpected process crashes. If you find that icCube's performance is suboptimal, you can then monitor the usage of
this swap space.

### Native Memory Overhead

The previous example is using quite a **small heap** for icCube. The native memory overhead is significantly higher 
when contrasted with the heap size set to `512m`. This overhead **tends to decrease** as the heap size increases 
(e.g., tens of gigabytes). For instance, we observed overheads of `1-2g` for `32g` heaps.

### Chrome Headless (Printing)

Printing dashboards is performed using Chrome|Chromium in headless mode that will require some memory as well.

To investigate a bit the memory required by Chrome, let's start a container with `4g` of memory and `no swap`
(for the sake of simplicity) and a Java heap of `1g` :

    sudo docker run -d \
        --name ic3 \
        --memory 4g --memory-swap 4g \ 
        -e ICCUBE_JAVA_OPTS="-Xmx1g -XX:NativeMemoryTracking=summary" \
        -e ICCUBE_CHROME_NO_SANDBOX=1 \
        -v $ICCUBE_BIN/icCube-4.lic:/opt/icCube/bin/icCube-4.lic \
        -v $ICCUBE_BIN/icCube.xml:/opt/icCube/bin/icCube.xml \
        -p 8282:8282 \
        ic3software/iccube:8.4.6

assuming `ICCUBE_BIN` contains the path to the host folder containing the files `icCube-4.lic` and `icCube.xml`
with the printing feature activated and licensed.

Once started you can launch the Admin interface and check that Chrome|Chromium is available along with a bunch
of information related to the print server :

![Print Server](images/print-status.png)

In the picture above, we can see that the Docker is using Chrome (version `117.0.5938.88`) and that icCube
has been configured for allowing `4` print jobs in parallel. 

After playing a bit with icCube and printing a bunch of dashboards, we can run a shell into the Docker
to check the memory usage of the different processes :

    # sudo docker exec -it ic3 /bin/bash
    # top -o %MEM

    PID USER      PR  NI    VIRT    RES    SHR S  %CPU  %MEM     TIME+ COMMAND                                                                                      
      1 ic3       20   0   10.6g 671784  40884 S   0.0   1.0   0:23.17 java                                                                                         
     64 ic3       20   0   32.6g 176164 148024 S   0.0   0.3   0:00.89 chrome                                                                                       
    102 ic3       20   0   32.3g 101356  88604 S   0.0   0.2   0:00.42 chrome                                                                                       
    149 ic3       20   0 1131.9g  82400  66716 S   0.0   0.1   0:00.02 chrome                                                                                       
    101 ic3       20   0   32.5g  73352  56660 S   0.0   0.1   0:00.09 chrome                                                                                       
     81 ic3       20   0   32.3g  59796  48208 S   0.0   0.1   0:00.02 chrome                                                                                       
     80 ic3       20   0   32.3g  59332  47792 S   0.0   0.1   0:00.01 chrome                                                                                       
    103 ic3       20   0   32.4g  47296  35348 S   0.0   0.1   0:00.02 chrome                                                                                       
    273 ic3       20   0    7160   3820   3328 S   0.0   0.0   0:00.05 bash 
    ...

On top of the Java (`PID=1`) process representing the icCube server, several Chrome processes are using 
the memory as well. So you should take them into account when configuring the memory allocated to the Docker.

### See Also

Please refer to this [page](../MemoryUsage.md) for a series of documents related to the memory usage in icCube.

### Contact Us

Do not hesitate to [contact us](https://www.iccube.com/contact-us/) for some help configuring the memory.

_