## On-The-Fly Authorization

This section describes how to define the content of a user's role when this user is connecting to icCube.

On-the-fly authorization is typically used when [embedding](./Embedded.md) icCube into an existing application.
In this scenario, **users** are managed by the host application (i.e., not defined in icCube). The **roles**
of these users can be either fully defined in icCube or fully managed by the application (i.e., defined when
the users are connecting to icCube) or a mix of the both.

The following sections are mainly showing how to define the different parts (i.e., applications, schemas,
dashboards, docs) of a role definition:

![Role Definition](./onthefly/images/role-definition.png)

### Header Authentication Service

As described in the [Embedding icCube](./Embedded.md) section, the `IcCubeHeaderAuthenticationService` is the
actual service performing both the authentication and the authorization in icCube. The authentication part is
basically doing nothing as the host application is responsible for it. This service allows for different ways for
defining the authorization (i.e., defining the role of the connecting user) depending on the host application
requirements.

Note that this service can be used with or without on-the-fly mode being activated. Enabling the on-the-fly
authorization is configured with the `header.role.onTheFly` parameter (`icCube.xml`):

```xml

<icCubeAuthenticationService>

    <service-class>crazydev.iccube.server.authentication.IcCubeHeaderAuthenticationService</service-class>

    <param>
        <name>header.role.onTheFly</name>
        <value>true</value>
    </param>

</icCubeAuthenticationService>
```

This service is extracting at run-time the required information from the HTTP headers sent by the HTTP client.
For example, the following is authorizing the user `marc` using the role `standard` (as defined wihtin icCube).
Eventually this user is configured with the French locale.

```
ic3-User  : marc
ic3-Role  : standard
ic3-Locale: FR
```

Without the `on-the-fly` being activated, this service expects the `user` and `role` headers and optionally
the `locale` and `tenant` headers.

#### User

The `user` HTTP header defines the name of the user being connected to icCube. This name is used for:

- logging purpose,
- audit purpose,
- for defining the home directory in the Docs repository (e.g., dashboards, ...),
- possibly selecting the right MDX execution profile (see icCube.xml `mdxEvalConfiguration`).

Default HTTP header name: `ic3-User`. The name of the HTTP header can be changed with the following parameter
(`icCube.xml`):

```xml

<param>
    <name>header.user</name>
    <value>IC3_USER</value>
</param>
```

#### Locale

The optional `locale` HTTP header defines the locale of the user being connected to icCube. This is the name
of a JAVA locale.

When no locale is provided the default locale of the service is being used  (`icCube.xml`):

```xml

<param>
    <name>header.default.locale</name>
    <value>FR</value>
</param>
```

Default HTTP header name: `ic3-Locale`. The name of the HTTP header can be changed with the following parameter
(`icCube.xml`):

```xml

<param>
    <name>header.locale</name>
    <value>IC3_LOCALE</value>
</param>
```

#### Tenant

The optional `tenant` HTTP header defines the name of the tenant of the user being connected to icCube.

Default HTTP header name: `ic3-Tenant`. The name of the HTTP header can be changed with the following parameter
(`icCube.xml`):

```xml

<param>
    <name>header.tenant</name>
    <value>IC3_TENANT</value>
</param>
```

#### Role

The `role` HTTP header defines the name of the role of the user being connected to icCube. This role must be defined
within icCube. Use the builtin `Administrator` role to authorize a user as an **administrator** of icCube (in that
case the `header.role.onTheFly` configuration of the service is ignored).

When the `header.role.onTheFly` is activated, this role is used as a **template** to generate the actual
role definition of the user: the generated role is using the `Applications` and `Schemas` and `Dashboards`
and `Docs` parts of the template role:

![Role Definition Applications](./onthefly/images/role-definition-applications.png)

Default HTTP header name: `ic3-Role`. The name of the HTTP header can be changed with the following parameter
(`icCube.xml`):

```xml

<param>
    <name>header.role</name>
    <value>IC3_ROLE</value>
</param>
```

#### MDX Role (On-The-Fly)

MDX queries are processed using an MDX execution profile (see icCube.xml `mdxEvalConfiguration` section).
Those profiles can be selected using the role of the user running the query. When using on-the-fly authorization
the name of this role is dynamically created and therefore cannot be used in the `icCube.xml` profile selector
definition. The `mdx-role` HTTP header allows for defining this name.

Default HTTP header name: `ic3-Mdx-Role`. The name of the HTTP header can be changed with the following parameter
(`icCube.xml`):

```xml

<param>
    <name>header.mdxRole</name>
    <value>IC3_MDX_ROLE</value>
</param>
```

#### Docs Role (On-The-Fly)

The `Docs` content is accessed according to the defined permissions that are based on user's role.
If these permissions are defined in the `Docs` directly, then when using on-the-fly authorization the name 
of the user's role is dynamically created and therefore cannot be used in advance to define the `Docs` 
permissions definition. The `docs-role` HTTP header allows for defining this name.

Default HTTP header name: `ic3-Docs-Role`. The name of the HTTP header can be changed with the following parameter
(`icCube.xml`):

```xml

<param>
    <name>header.docsRole</name>
    <value>IC3_DOCS_ROLE</value>
</param>
```

#### Schemas (On-The-Fly)

The `schemas` or `schemas-perms` HTTP headers define the content of the `Schemas` part of the role of the user
being connected to icCube:

![Role Definition Schemas](./onthefly/images/role-definition-schemas.png)

Default HTTP header names: `ic3-Schemas` or `ic3-Schemas-Perms`. The names of the HTTP header can be changed
with the following parameter (`icCube.xml`):

```xml

<param>
    <name>header.schemas</name>
    <value>IC3_SCHEMAS</value>
</param>
```

```xml

<param>
    <name>header.schemas.perms</name>
    <value>IC3_SCHEMAS_PERMS</value>
</param>
```

Please refer to this [page](./onthefly/OnTheFlyAuthSchemas.md) for detailed information about the different ways
of defining this header.

#### Dashboards Denied Features (On-The-Fly)

The `dashboards` HTTP header defines the content of the `Dashboards` part of the role of the user being connected
to icCube:

![Role Definition Dashboards](./onthefly/images/role-definition-dashboards.png)

Default HTTP header name: `ic3-Dashboards`. The name of the HTTP header can be changed with the following parameter
(`icCube.xml`):

```xml

<param>
    <name>header.dashboards</name>
    <value>IC3_DASHBOARDS</value>
</param>
```

Please refer to this [page](./onthefly/OnTheFlyAuthDashboards.md) for detailed information about the definition
of this header.

#### Docs (On-The-Fly)

The `docs` HTTP header defines the content of the `Docs` part of the role of the user being connected to icCube:

![Role Definition Docs](./onthefly/images/role-definition-docs.png)

Default HTTP header name: `ic3-Docs`. The name of the HTTP header can be changed with the following parameter
(`icCube.xml`):

```xml

<param>
    <name>header.docs</name>
    <value>IC3_DOCS</value>
</param>
```

Please refer to this [page](./onthefly/OnTheFlyAuthDocs.md) for detailed information about the definition
of this header.

#### Troubleshooting

On-the-fly is all about defining dynamically the content of a role, so instead of starting from scratch defining
the role (and more specifically the `Schemas` part) this way, we strongly advise defining first 2-3 representative
roles in icCube for testing the permissions are fine. This role can be switching dynamically using the `role`
header as explained in this document. Once everything has been validated, then for example the `Schemas` part
can be dynamically generated as well.

The actual created permissions can be monitored in the `Administration` interface using the `Server/Permissions`
use case. Look there for the `On-The-Fly` permissions and the ones with the role name starting with `$META$`
and/or `$OFT$`.

The logs are a great source to understand what is going on with the authorization. Ensure to have the `log4j.xml`
file containing the following:

```xml
<Logger name="icCube.http.request" level="debug"/>
<Logger name="icCube.authentication" level="debug"/>
<Logger name="icCube.authorization" level="debug"/>
<Logger name="icCube.authorization.headers" level="debug"/>
<Logger name="icCube.authorization.onTheFly.content" level="debug"/>
```

With that in place, you can look at the HTTP headers being received by icCube as well as searching for the `[auth]`
pattern in the log files for troubleshooting the authorization setup.

In any case, do not hesitate to contact us for some help configuring the on-the-fly authorization.

### Contact Us

Support for the on-the-fly authorization is constantly evolving to meet specific requirements so do not hesitate to
[contact us](https://www.iccube.com/contact-us/) for more details or for requesting some new features.

_
