## Memory Usage

The icCube server functions as an in-memory analytical engine, so meticulous attention is needed to properly
configure the server memory for an optimal behavior of icCube. Since the server is implemented in Java, configuring
the server memory requires knowledge of the Java runtime behavior regarding the RAM usage.

**Executive Summary**

When running icCube, the **total memory** used by the Java process will be the **heap** memory (i.e., `-Xmx` 
parameter defined at runtime) plus the memory used by the Java Virtual Machine (aka. JVM) itself known as 
**native** memory.

Pay attention that for small heap values (e.g., `-Xmx512m`) the native memory **overhead** is significantly 
higher when contrasted with the heap size value (e.g., `800m`) leading to a total of about `1.3m` of total 
memory usage. This overhead **tends to decrease** as the heap size increases (e.g., tens of gigabytes). For 
instance, we observed overheads of `1-2g` for `32g` heaps.

If you are unable to provision enough RAM for the machine/container running icCube, we recommend using 
some **swap space** as a precautionary measure to prevent any unexpected process crashes. If you find that
icCube's performance is suboptimal, you can then monitor the usage of this swap space.

The following documents will help you configure the server memory.

### Java Process

Please refer to this [page](memory/MemoryJavaProcess.md) for a detailed explanation of the memory usage within
a Java process.

### Java Garbage Collector

Please refer to this [page](memory/MemoryJavaProcessGC.md) for additional considerations regarding the
Java garbage collector.

### Docker Container

Please refer to this [page](memory/MemoryDockerContainer.md) for additional considerations regarding the icCube 
server when deployed in a Docker container.

### Schema Memory

Please refer to this [page](memory/MemorySchema.md) for a detailed explanation of the memory required for loading
a schema.

### Low RAM/CPU Configuration

Please refer to this [page](memory/MemoryLowRamConfiguration.md) for a detailed explanation about configuring
icCube in accordance with low RAM/CPU constraints.

### Contact Us

Do not hesitate to [contact us](https://www.iccube.com/contact-us/) for some help configuring the memory.

_