## Embedding icCube

This section describes how to embed icCube Dashboards (and the Administration interface) into your own Web application
according to different architectures.

![Overview](./embedded/images/embedded-overview.png)

### Overview

- The icCube server is placed behind the **Web server** used by the host application and is not directly accessible from
  Web browsers or REST API clients.

- The host application is responsible to perform the user's **authentication**. Doing this way, there is no
  need to define the users in icCube. There will be a single authentication mechanism as required by your company
  policy.

- Once the user has been successfully authenticated, the host application sends some information to icCube to determine
  the role attached to this user (i.e., **authorization**). This can be the name of a role as defined within icCube, or
  some information for creating the role on-the-fly. More on this later in this document.

- The host web application's code is extended to add some **code embedding**, for example icCube dashboards.
  This can be as simple as adding an `iframe` using dashboard permalinks as source. A more flexible approach is to use
  the icCube [API](https://github.com/ic3-software/ic3-reporting-api-embedded) to control icCube from the host
  application
  (e.g., open dashboard, sent event to dashboards, etc…). The API can use a `div` or an `iframe` for embedding icCube.
  More on this later in this document.

### Host Backend

The host applications backend contains all the required components of the host application; it can be either simple or
complex depending on the actual application. In any case, it is acting as a Web server that is somehow _federating_ all
the required components for the client application.

**HTTP Reverse Proxy**

It is likely that the icCube server and the host application are not in the same domain. If that's the case, we strongly
advise putting in place some sort of _HTTP reverse proxy_ to avoid any security issues (e.g., iframe, CORS, ...)
within Web browsers when serving resources from different domains. For people using Amazon cloud services, a nice
overview of reverse proxy setups in Amazon service can be found in
this [blog](https://aws.amazon.com/blogs/architecture/serving-content-using-fully-managed-reverse-proxy-architecture/).

Using a single domain allows as well to manage HTTPS in a single point.

Without this reverse proxy, the host application would have to configure the CORS headers accordingly.

### icCube Web Server

The icCube server (written in Java) is using [Jetty](https://www.eclipse.org/jetty/) at its core. This Web server acts
as a _Java servlet container_. icCube applications (e.g., server administration, dashboards, etc...) are exposed as
regular Web applications. Those Web applications are _session based_. Out of the box, the `JESSIONID` cookie is being
used to keep track of those sessions.

### Authentication

With an embedded scenario, the user authentication is performed by the host application. Doing this way, there is no
need to define (and therefore duplicate) users in icCube. You can use whatever security is required by your company.

### Authorization

Access rights in icCube are defined using _roles_. An authenticated user is attached to a _single_ role.

This role defines:

- which applications (e.g., server administration, schema builder, dashboard editor, etc…) the user has access to and
  how the user can use them (read/only vs read/write mode),

- which dashboards the user can access (i.e., Docs permissions),

- which data (e.g,. dimension, members, facts, etc…) the user can see.

You can find more information about roles [here](../server/user_guide/security/security.md).

With an embedded scenario, the host application is responsible to send icCube information to determine the role
attached to the authenticated user. There are different ways to do so, depending on the actual requirements of the
host application:

- send the name of a role as defined within icCube,

- send the name of a role as defined within icCube for the applications' permissions and the name of a schema
  this user has access to,

- send the name of a role as defined within icCube for the applications' permissions and some information to
  fully define on-the-fly the schema permissions. For example, a list of countries the role has access to.

Please refer to this [page](./OnTheFlyAuthorization.md) for more details.

### Cookie (Session-Oriented)

For this scenario, we assume the host application is _session-based_, which matches the icCube architecture.

Refer to this [page](./embedded/EmbeddedCookie.md) for detailed information and configuration.

### JWT-Token (Session-Less)

For this scenario, we assume the host application is _session-less_ and uses a `JWT-Token` to pass around
user's claims from which the icCube authorization is built upon. This scenario is not strictly limited to `JWT-Token`.

A _session-less_ approach requires more configuration to match icCube's requirements (the authorization information
could be passed using an alternate mechanism).

Refer to this [page](./embedded/EmbeddedJwtToken.md) for detailed information and configuration.

_
