## Text Widget

### Overview

A text widget displays textual information using the syntax of the markdown (GitHub Flavored Markdown (GFM))
markup language ([www](https://www.markdownguide.org/basic-syntax/)). The text can contain some HTML code as well.

### Links

Should you need to insert a link use the following syntax:

```
    [caption](https://...)
```

As an example, the following is opening the icCube page:

```
    [icCube](https://www.icCube.com)
```

[icCube](https://www.icCube.com)

### Images

Should you need to insert an image use the following syntax:

```
    ![caption](https://...)
```

As an example, the following is opening the icCube logo:

```
    ![icCube](https://downloads.iccube.com/assets/logo.svg)
```
Or, if you need to resize the image, you can directly use HTML:

```
<img src="https://downloads.iccube.com/assets/logo.svg">
```



<img src="https://downloads.iccube.com/assets/logo.svg">



### Relative Links

Relative URLs depend on the current page URLs. For a standard icCube deployement, those URLs are more likely
relative to `/icCube` and are pointing to the `Web Public` folder of the server `Docs`.


### KaTeX

The text widget can render [KaTeX](https://katex.org/) expressions, a math typesetting library, useful for displaying mathematical expressions and formulas. 

Start and end a KaTeX expression with `$`. To center the text, start and end with `$$`.

For example, the following expression:

```
$$y \sim \alpha_0 + \alpha_1x_1 + \alpha_2x_2 + \ldots  + \alpha_nx_n$$

```
returns:

$$y \sim \alpha_0 + \alpha_1x_1 + \alpha_2x_2 + \ldots  + \alpha_nx_n$$

This [page](https://katex.org/docs/supported.html) lists the available functions. Note that not all TeX objects are supported, for example, external packages can't be included.

### Appearance

The text widget have the following configuration.

_Variant_ \
The following variants are available:

* Plain: plain markdown
* Documentation: Used by the documentation dialog
* Help (Box): Used by the widget box tooltip/help icon
* Tooltip: Used for data tooltips in the charts
* Dashboard Theme: Based on dashboard theme definition (h1,h2...)


### Localization

To translate (localize) multi-lined markdown text, follow the instructions on this [page](../../../localization/ContentLocalization.md#multi-line-markdown-text-localization).


_



