## KPI Card

### Overview

A key performance indicator (_KPI_) is a metric that provides a summary of one or more processes in a company. Most KPIs
have target values. Looking at a KPI should give its owner a general idea of what to do next.

Take a production line for example, the operational manager measures the number of units produced and compares this
against the target for that day. This action in itself is valuable, since the manager can then take action for any
deviation. Moreover, using the historical values of this KPI, he or she can spot trends and can compare the current
performance to past performance.

For examples, see
the [report with kpi cards](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FKPI%2FKPI+card).

### Data

#### Query Builder

The query for the basic KPI card consists on displaying a single value.

![KPI Card Query Builder](images/kpicard-query-builder.png)

To include a comparison value and historical data, use the MDX query example below.

#### MDX Query

An MDX query is not as straightforward if we want to include the historical data as well. Have a look at the query below. The `WITH MEMBER` statements calculate all the measures that we need for the KPI card. 

```
WITH 
MEMBER [Measures].[Target] AS 10
MEMBER [Measures].[#Customers 2020 Jan] AS ([Time].[Time].[Month].[2020 Jan],[Measures].[#Customers] )
MEMBER [Measures].[Hist] AS Vector( [Time].[Time].[Month].members, [Measures].[#Customers] )
SELECT
{[#Customers 2020 Jan], [Measures].[Target], [Measures].[Hist]} ON 0
FROM [Sales]
```

The query results in the following tidy table.

|&nbsp;|#Customers 2020 Jan<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Target<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Hist<br><span style="font-weight:normal;color:gray">&lt;list&gt;</span>|
|:---|---:|---:|:---|
|0|8|10|4,6,...,7,1|

The KPI card maps the customer count in 2020 Jan automatically. The others you will have to map yourself. Note that the historical data can only take vectors or lists.

### Configuration

The KPI card can be configured as follows in the _Chart_ tab.

#### Mapping

The input data for the KPI card can consist of the following items:

_Value_ \
The current KPI value.

_Target_ \
Optional, the value to compare the KPI value against. This can be a target if the KPI has a target defined, or it can be the KPI value of a previous period. In the latter case, you can show an icon that indicates the trend of the kpi card.


_Target Delta Zero_ \
If the target value is below the delta value, the target value is considered as zero (to solve rounding issues).
By default, this value is set to 10<sup>-9</sup>.


_Historical data_ \
Optional, a list of historical KPI values.


#### Appearance

_Text_ \
Here you configure the settings of the title, the KPI value and the target. If the KPI has a target value, then you can
for example set the _Target Text_ to 'of target' and disable the icon. If, however, the target is the KPI value in a
previous period, then you should enable the trend icon.

The colors of the percentage indicates whether an increase in the KPI value compared to the target value is good or bad.
The default settings is that a higher KPI value is better. This is flipped by setting the _Interpretation_ setting to 'Less = better'. To have no interpretation, and thus no coloring of the text, you set this setting to 'No
interpretation'.

_Sparkline_ \
With the settings in this group you can style the sparkline. The color of the sparkline is the same as the color for the
compare percentage. You can alter the styling of the hover line and circle in the theme.

_
