## KPI Box

### Overview

With the KPI box you can define your own template using Markdown. This is useful for custom visualisations, such as bar
renderers, icon renderers or info cards. For examples, see
the [KPI box report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FKPI%2FKPI+box).

### Data

The query for the KPI box is general, you only need to set the columns and the rows. See the following example. We use
the top 5 countries with the most licences and we calculate the percentage of the total with a transformation.

![KPI Box Query Builder](images/kpibox-query-builder.png)

This produces the following result.

|<b></b>|Country<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Articles<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|#Licences<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Amount AVG<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|#LicencesPERCENT<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|---:|---:|---:|
|0|France|5|4005|€5,261|48.1%|
|1|United States|5|2178|€4,657|26.2%|
|2|South Africa|4|810|€2,419|9.7%|
|3|Switzerland|5|748|€3,468|9.0%|
|4|Netherlands|5|584|€2,771|7.0%|

You can use the resulting table in the markdown content of the KPI box. We'll show in the next section.

### Configuration

The KPI box can be configured as follows in the _Chart_ tab.

#### Appearance

_Variant_ \
The following variants are available:
* plain: plain markdown
* doc: Used by the documentation dialog
* widgetHelp: Used by the widget box tooltip/help icon
* tooltip: Used for data tooltips in the charts
* dashboardTheme: Based on dashboard theme definition (h1,h2...)

_Markdown_ \
In _Markdown_, you can set the content for the widget. This is an expression that returns markdown for each row in the table. For more information about expressions, see [the html row expression help](../../../tidyTable/TidyTableHtmlRowExpression.md). Consider the example below.
```markdown
$Country$: $#Licences$ ($#LicencesPERCENT$)
<div style='width:100px; border: 1px solid black;'>
  <div style='width:$#LicencesPERCENT$; background:#08E6FC;'>&nbsp;
  </div>
</div><br>
```
If we use the table in the example above, then this results in the following output.

<p>France: 4,005 (48.1%)</p>
<div style="width:100px; border: 1px solid black;">
  <div style="width:48.1%; background:#08E6FC;">&nbsp;
  </div>
</div><br>
<p>United States: 2,178 (26.2%)</p>
<div style="width:100px; border: 1px solid black;">
  <div style="width:26.2%; background:#08E6FC;">&nbsp;
  </div>
</div><br>
<p>South Africa: 810 (9.7%)</p>
<div style="width:100px; border: 1px solid black;">
  <div style="width:9.7%; background:#08E6FC;">&nbsp;
  </div>
</div><br>
<p>Switzerland: 748 (9.0%)</p>
<div style="width:100px; border: 1px solid black;">
  <div style="width:9.0%; background:#08E6FC;">&nbsp;
  </div>
</div><br>
<p>Netherlands: 584 (7.0%)</p>
<div style="width:100px; border: 1px solid black;">
  <div style="width:7.0%; background:#08E6FC;">&nbsp;
  </div>
</div><br>

_
