## Embedded Dashboard

### Overview

The embedded dashboard widget displays another icCube dashboard. See
this [page](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FMiscellaneous%2FEmbedded+Dashboard)
for a live example.

Below, find step-by-step examples on how to create:
- [Embedded Dashboard](#embedded-dashboard)
  - [Overview](#overview)
  - [Configuration](#configuration)
    - [Example 1: Unique Embedded Dashboard](#example-1-unique-embedded-dashboard)
    - [Example 2: Embedded Dashboard from an event](#example-2-embedded-dashboard-from-an-event)
    - [Example 3: Embedded Dashboard with events (in or out)](#example-3-embedded-dashboard-with-events-in-or-out)
    - [Part 1: Event 'host' to embedded](#part-1-event-host-to-embedded)
    - [Part 2: Event embedded to 'host'](#part-2-event-embedded-to-host)

### Configuration

The configuration of the Embedded Dashboard is done in _Chart_ options. Make sure to have a previously saved dashboard before using the Embedded Dashboard widget.

_Title_ \
Title of the Embedded Dashboard widget.

_Dashboard Name_ \
Input here the dashboard's path. Browsing the repository is available.

_Event (TO) / (FROM)_ \
Input here if the embedded dashboard is receiving or passing events.


#### Example 1: Unique Embedded Dashboard 

The standard use of the embedded dashboard is directly choosing a unique dashboard to display. 

An example could be inputting `shared:/Live Demo/Embedded Dashboard/Embedded Dashboard` under _Chart_ > _Dashboard Name_.


#### Example 2: Embedded Dashboard from an event

This example shows how to set up an embedded dashboard widget, where the dashboard to be displayed are the result of an
event.

![Embedded Dashboard from Event](images/emb-dash.png)

Create a [Buttons filter](../filter/FilterButtons.md) and select Table Definition as data source. The table should
contain the displayed dashboard names and the paths as `uniqueName` (case-sensitive syntax). Read more about table queries for
filters [here](../../../query/FilterTableDefinitionQuery.md)

```
dashboard   ,dashboard@uniqueName
Bar         ,shared:/Live Demo/Charts/Bar
Bubble      ,shared:/Live Demo/Charts/Bubble
Line        ,shared:/Live Demo/Charts/Line
Treemap     ,shared:/Live Demo/Charts/Treemap
```

Define the name of your event, e.g. `myselecteddashboard`, under _Interaction_ > _Selection_ > _Publish Selection_.

Create an Embedded Dashboard and set the event's accessor as the _Dashboard Name_.

![Embedded Dashboard from Event Configuration](images/emb-dash-event.png)

Read more about events accessors [here](../../../interactions/Events.md#event-accessors).

#### Example 3: Embedded Dashboard with events (in or out)

#### Part 1: Event 'host' to embedded

To send an event **to** an embedded dashboard widget, in other words, make the event available inside the embedded dashboard, follow the steps below:

- Create an event on the 'host' dashboard, i.e. dashboard containing an embedded dashboard widget. It could for example be a buttons filter with years, the event name is set to `year`.
- Set the `year` event on the Embedded dashboard configuration as an Event (TO) and Event (FROM):

![Embedded to from](images/emb-to-from.png)

- Set the `year` event as a Constant within the embedded dashboard content:

![Embedded constant](images/emb-constant.png)

- Now the event is available on the query tree to be added to charts:

![Embedded available](images/emb-available.png)

- The embedded dashboard's charts is responding to the event of the 'host' dashboard:

![Embedded to](images/emb-to.png)


#### Part 2: Event embedded to 'host'

To send an event **from** an embedded dashboard widget, in other words, make the event available outside the embedded dashboard, follow the steps below:

- Create an event on the embedded dashboard. It could for example be a click on a donut's slice, we'll call it `continent`:

![Embedded event continent](images/emb-continent.png)

- On the 'host' dashboard, set the `continent` event on the Embedded dashboard configuration under the Events Fired (out):

![Embedded to from](images/emb-from-out.png)

- Set the `continent` event as a Constant within the 'host' dashboard :

![Embedded from constant](images/emb-from-constant.png)

- We create a Column chart in the 'host' dashboard and now the `continent`event is available on the query tree to be added to charts:

![Embedded from available](images/emb-from-available.png)

- The donut in the embedded dashboard is filtering the column chart of the 'host' dashboard:

![Embedded from](images/emb-from.png)

_
