## Selection from a CSV (Table Definition) DataSource

You want the filter to have the following options to select from. 

```
28 May
Last week of May
Month of May
```

Follow these steps
1. In the _Query_ tab, click on '_Datasource_ and change it to 'Table Definition'
2. Paste the following in the query and press apply
```
item
28 May
Last week of May
Month of May
```

3. To make the event value different from the display value, use this table

```
item,item@uniqueName
28 May,"[Time].[Time].[day].[28 May 2021]"
Last week of May,"[Time].[Time].[day].[24 May 2021]:[Time].[Time].[day].[31 May 2021]"
Month of May,"DESCENDANTS([Time].[Time].[month].[2021 May],1)"
```

The '@' sign sets 'uniqueName' as a property of the 'item' column. Column 'uniqueName' contains the event value for each
item. Note that `uniqueName` is a case-sensitive syntax.

_
