## Filter: Tree

You can add filters to your report so that users can filter the queries in the report. The filter tree widget renders
options as radio buttons or checkboxes. Special about this widget, is that it can show hierarchies as trees.

Check
the [tree filter live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FFilters%2FTree).

### Data

#### Query Builder

The tree expects a list of members that the user can select. To show hierarchies as trees, drag & drop different levels
of a same hierarchy, in order, into the _Items_ field and add the Hierarchize function.

![Tree Query Builder](images/tree-query-builder.png)

#### MDX Query

To build a tree filter from an MDX query, you can for example use
the [Hierarchize()](../../../server/mdx/Hierarchize.md) function:

```
SELECT
   Hierarchize({[Time].[Time].[Year],[Time].[Time].[Quarter],[Time].[Time].[Month]}) ON 0
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```

or the [Descendants()](../../../server/mdx/Descendants.md) function
```
SELECT
Descendants([Time].[Time].[Year]) on 0
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```

#### CSV Data Source

You can have a CSV data source by using 'CSV (Table definition)' as the query type. CSV sources do not have MDX
properties, but we can still use them to make filters. Below we show an example that allows for filters with custom MDX.

```
item,               item@uniqueName
28 May,             "[Time].[Time].[day].[28 May 2021]"
Last week of May,   "[Time].[Time].[day].[24 May 2021]:[Time].[Time].[day].[31 May 2021]"
Month of May,       "DESCENDANTS([Time].[Time].[month].[2021 May],1)"
```

Note that `uniqueName` is a case-sensitive syntax.

Read more about embedded data sources and filters in [Selection from a Table Definition DataSource](SelectionFromEmbedded.md).


### Interaction options

In the _Interaction_ tab, you can change the selection behavior of the filter.

You can change the initial selection of the filter by
* manually selecting the items in _Initial Selection User Defined_,
* or by setting a column into _Initial Selection Column_. Items on the row where this column returns true are in the initial selection.

With _Publish-_ and _Subscribe Selection_ you can connect the filter to events.

### Tree options

You can choose the size of the tree items in the _Chart_ tab of the editor. The tree widget does not have variants.

_Item_ \
In the item group, you can select the column with items to use in the filter. The _Items_ use items in the builder or the first character column as the default.

Also, you can set some items to inactive by selecting a column in the _Active_. If this column has a value that evaluates to true, then the item of that row is active. Otherwise, the item is inactive, and the user cannot select it.

To change the colors of the items, you can map a color column in _Color_. This changes the colors of the items that are not selected. 

_Selection Color_ sets the color of items in the selected state. Leave blank to use the theme's default selection color.

_Tree_ \
Here you can change if the tree should show the radio- or checkbox button. 

Also, you can set the initial expansion depth.

_Selection_ \
If you have a tree with multiple selection, then selecting a parent in the tree can do two things. Per default, only the
parent gets selected. If you enable _Cascade Selection_, then selecting a parent selects all children and deselecting a
parent unselects all its children.

'Fire Mode' controls what items are in the selection event. The default, 'Fire compacted', sends only the parent when
the user selects all children. 'Fire all' sends all items.

_Add Search_ \
Enable this if you want a search bar for the user. With the search bar, the user can search the items in the tree. Also,
you can set the placeholder text of the search bar in _Search Placeholder_.

_Dropdown_ \
By enabling _Dropdown_, you can transform the tree to a dropdown filter with the items shown in a tree. You can set the variant and sizeof items, as well as _Limit Items_ which is the maximum number of visible items in the dropdown.

_
