## Filter: Slider

You can add filters to your report so that users can filter the queries in the report. The slider widget shows the
options on a slider. With it, the user can select a single item or a range of items.

Check
the [slider live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FFilters%2FSlider).

### Data

#### Query Builder

A slider widget expects a list of items that the user can select from.

![Slider Query Builder](images/slider-query-builder.png)

#### MDX Query

To build a slider widget from an MDX query, define a query that results on a list of items, such as:

```
SELECT
   [Geography].[Geography].[Continent] ON 0
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```

#### CSV Data Source

You can have a CSV data source by using 'CSV (Table definition)' as the query type. CSV sources do not have MDX
properties, but we can still use them to make filters. Below we show an example that allows for filters with custom MDX.

```
item,               item@uniqueName
28 May,             "[Time].[Time].[day].[28 May 2021]"
Last week of May,   "[Time].[Time].[day].[24 May 2021]:[Time].[Time].[day].[31 May 2021]"
Month of May,       "DESCENDANTS([Time].[Time].[month].[2021 May],1)"
```

Note that `uniqueName` is a case-sensitive syntax.

Read more about embedded data sources and filters
in [Selection from a CSV (Table Definition) DataSource](SelectionFromEmbedded.md).

### Interaction Options

In the _Interaction_ tab, you can change the selection behavior of the filter. With multiple selection, the user can select a range of items.

You can change the initial selection of the filter by
* manually selecting the items in _Initial Selection User Defined_,
* or by setting a column into _Initial Selection Column_. Items on the row where this column returns true are in the initial selection.

If the slider has multiple selection, then it will display the initial selection as a range from the first to the last value of the selection. For example, if you have the years 2010 to 2020 as items, and the initial selection is 2015, 2017, then the event fires 2015 and 2017, and the slider shows the range 2015 to 2017. Note that 2016 is not fired in the event. To fire it as well, include it in the initial selection.  

With _Publish-_ and _Subscribe Selection_ you can connect the filter to events.

### Slider Options

You can choose the size of the slider and its button in _Size_. The slider does not support variants.

_Item_ \
In the item group, you can select the column with items to use in the filter. The _Items_ use items in the builder or
the first character column as the default.

Also, you can set some items to inactive by selecting a column in the _Active_ field. If this column has a value that
evaluates to true, then the item of that row is active. Otherwise, the item is inactive, and the user cannot select it.

To change the colors of the buttons, you can map a color column in _Color_. This changes the colors of the items that
are not selected. 

_Selection Color_ sets the color of items in the selected state. Leave blank to use the theme's default selection color.

_Slider_ \
Here you can change the layout of the slider. 

Sometimes, the left- or rightmost item does not fit the widget. In that case, you can change the margin in _Margins_.

When there is an important number of members on the slider, prefer 'Tooltips (on)' _Style_ instead of the 'Marks' default and add a _Selection Label_. 

#### See Also

See this [page](../../Filters.md#using-filter-widgets-for-defining-mdx-axes) for using filter widgets to define a query's axis.

_
