## JSON: Allowed and Not Allowed Filters

With this field, you control what filters are allowed/not allowed in the filter panel. 

The syntax of this field is a JSON array of filter IDs. The ID of a filter looks like:
- Hierarchy: `[dimension].[hierarchy]`
- Level: `[dimension].[hierarchy].[level]`
- Level Property: `[dimension].[hierarchy].[level].[property]`

The following shortcuts are available:
- `[...].all` to use all from the dimension/hierarchy/level,
- `[...].hierarchies` to use only the hierarchies from the dimension/hierarchy/level.
- `[...].levels` to use only the levels in the dimension/hierarchy/level,
- `[...].properties` to use only the properties in the dimension/hierarchy/level,

### Examples

The following example describes the filters from the `customer` dimension; the levels from the `time` hierarchy; and the `country` property:

```
[
    "[Customer].all",
    "[Time].[Time].levels",
    "[Geography].[Geography].[City].[Country]"
]
```