
## Filter: Filter Panel

The filter panel widget allows the dashboard user to add filters to the dashboard. The user can filter a level or a
property from the cube by adding rules that select members from that level. For example, the Country name starts
with `South`.

![filter panel](images/filter-panel.png)

Check
the [filter panel live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FFilters%2FFilter+Panel).

### Data 

The filter panel does not require a query to work. Per default, it takes the schema information from the report and adds all the levels and properties that are available.

### Configuration

*Horizontal layout* \
The filter panel can have a horizontal layout.

*As Global Filter* \
Each widget with a query has the option to use the global filter. This option is in the interactions tab. If it is enabled, then the filter panel filters the widget if 'As Global Filter' is true. 

If you wish to filter only some widgets, then you can either disable the 'Use Global Filter' option or use the event generated by the filter panel. 

*Schema Name* \
If you want to use a different schema, set the name here.

*Cube Name* \
Per default, it uses the first cube from the schema. If you want to use another cube, set its name here.

*Allowed Filters* and *Not Allowed Filters* \
with these lists, you control what filters are available to the user to choose from. The filters the user can choose from are defined as follows:
* Take all the allowed filters (or all if it is empty), and remove the not allowed filters.
* Filters in the Default filters can always be selected.

Note, you can easily change the *Allowed Filters* by clicking 'Set Allowed Filters' in the user menu of the widget header.

Not allowed filters show an error message if they are restored from a saved filter state.

See [JSON: Allowed and Not Allowed Filters](FilterPanelAllowedFilters.md).

*Default Filters* \
Show these filters when opening the dashboard. You can easily change the values here by clicking 'Set Default Filters' in the user menu of the widget header.

*Measure MDX* \
Set here a measure from the cube. If defined, the panel filter only shows members with a non-null value for this measure. Other members are not shown in the results.

For simple filters, the options without any data are greyed out.

*Property Name Template* \
Control the caption of the property-filters.

*Use Simple Filter* \
Show a checkbox selection filter if the filter has less than `x` items. You can set `x` in this field. 

*Hide Property Filters* \
Do not allow property filters.

*Allowed Operators* \
The user can select only from these operators. If there is just one operator the user can select from, then the filter panel hides all operator selector dropdowns.

*Date Picker Shortcuts* \
In date pickers or date-range pickers, the filter panel shows shortcuts if this option is enabled.

### See Also

See [how to use a filter panel](FilterPanelUsage.md).

_
