## Filter: Buttons

You can add filters to your report so that users can filter the queries in the report. 

The filter buttons widget renders options as buttons the user can click on. It can be used
for [natural filtering purpose](../../Filters.md#using-filter-widgets-for-filtering) or
for [defining a query's axis](../../Filters.md#using-filter-widgets-for-defining-mdx-axes).

Check
the [buttons live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FFilters%2FButtons).

### Data

#### Query Builder
A buttons filter expects a list of items that the user can select from.

![Buttons Query Builder](images/buttons-query-builder.png)

#### MDX Query

To build a buttons filter from an MDX query, define a query that results on a list of items, such as:

```
SELECT
   [Time].[Time].[Year] ON 0
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```

#### CSV Data Source

You can have a CSV data source by using 'Table definition' as the query type. CSV sources do not have MDX properties,
but we can still use them to make filters. Below we show an example that allows for filters with custom MDX.

```
item,               item@uniqueName
28 May,             [Time].[Time].[day].[28 May 2021]
Last week of May,   [Time].[Time].[day].[24 May 2021]:[Time].[Time].[day].[31 May 2021]
Month of May,       "DESCENDANTS([Time].[Time].[month].[2021 May],1)"
```

Note that `uniqueName` is a case-sensitive syntax.

Read more about embedded data sources and filters
in [Selection from a CSV (Table Definition) DataSource](SelectionFromEmbedded.md).

### Interaction Options

In the _Interaction_ tab, you can change the selection behavior of the filter. 

You can change the initial selection of the filter by
* manually selecting the items in _Initial Selection User Defined_,
* or by setting a column into _Initial Selection Column_. Items on the row where this column returns true are in the initial selection.

With _Publish-_ and _Subscribe Selection_ you can connect the filter to events. 

### Button Options

You can choose the variant, and the size of the buttons in the _Chart_ tab of the editor. You can add your own variant in the theme, read more in [Theme components](../../../api/plugin/Theme.md#Components).

_Item_ \
In the item group, you can select the column with items to use in the filter. The _Items_ use items in the builder or the first character column as the default.

Also, you can set some items to inactive by selecting a column in the _Active_ field. If this column has a value that
evaluates to true, then the item of that row is active. Otherwise, the item is inactive, and the user cannot select it.

To change the colors of the buttons, you can map a color column in _Color_. This changes the colors of the buttons that
are not selected. 

_Selection Color_ sets the color of buttons in the selected state. Leave blank to use the theme's default selection color.

_Button_ \
The button can have the following layouts:

* Grouped: the buttons form a vertical group. Enable _Grouped_ to use it.
* Grid: the columns fill a grid, expanding in the row direction. To use it, set the _Grid Columns Count_ to a positive
  number. Setting this number to 0 will horizontally and vertically center the buttons.


#### See Also

See:

- this [page](../../../interactions/WidgetActions.md) for using a Buttons filter for widget actions (e.g. Export to Excel)
- this [page](../../../interactions/AppNotifications.md) for using a Buttons filter for application notifications (e.g. Print)
- this [page](../../Filters.md#using-filter-widgets-for-defining-mdx-axes) for using filter widgets to define a query's axis

_
