## Filter: Large Dropdown

You can add filters to your report so that users can filter the queries in the report.

The large dropdown widget renders options as a list of items the user can click on in an expanded menu. It can be used
for [natural filtering purpose](../../Filters.md#using-filter-widgets-for-filtering) or
for [defining a query's axis](../../Filters.md#using-filter-widgets-for-defining-mdx-axes).

Check
the [large dropdown filters live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FFilters%2FLarge+Dropdown).

### Sizing Consideration

Unlike the [Simple Dropdown](FilterAutocomplete.md), the large dropdown filter does not retrieve the whole list of items
from the server so it is well suited for large lists.

It has several limitations:

- coloring options are not supported,
- MDX query only,
- several interaction options are not available.

You might want to check the [filter panel](FilterPanel.md) that allows for a similar behavior.

### Data

#### Query Builder

A large dropdown widget expects a list of items that the user can select.

![Dropdown Query Builder](images/dropdown-query-builder.png)

#### MDX Query

To build the large dropdown widget from an MDX query, define a query that results on a list of items, such as:

```
WITH SET [my-items] as [Barcode].[Barcode].[Barcode].allMembers

SELECT

    IIF( "$$IC3-SEARCH$$" = "",
        Head( [my-items], $$IC3-LIMIT$$ ),
        Filter( [my-items] as t, PatternMatchesContains("$$IC3-SEARCH$$", t.currentMember.name, CASE_INSENSITIVE), $$IC3-LIMIT$$ )
    )
    ON "MdxBuilderFilterItems"

FROM [Cube]
CELL PROPERTIES CELL_ORDINAL
```

Notice the special tags that are replaced before the request is being sent to the server:

- `$$IC3-LIMIT$$`: the maximum number of member to return. The actual value depends on the configuration of your
  application (see [www](../../../gettingstarted/Configuration.md#limits)). Or instead of using that tag, you can
  use your own value directly.

- `$$IC3-SEARCH$$`: the value of the input of the large dropdown to filter the list of members. Feel free to replace
  the `PatternMatchesContains()` expression to meet your own needs.

### Interaction Options

In the _Interaction_ tab, you can change the selection behavior of the filter.

With _Publish-_ and _Subscribe Selection_ you can connect the filter to events.

### Large Dropdown Options

You can choose the variant, and the size of the large dropdown items in the _Chart_ tab of the editor. You can add your own
variant in the theme, read more in [Theme components](../../../api/plugin/Theme.md#Components).

_Item_ \
In the item group, you can select the column with items to use in the filter. The _Items_ use items in the builder or
the first character column as the default.

#### See Also

See this [page](FilterAutocomplete.md) for the simple dropdown supporting small to medium lists of items, and this [page](../../Filters.md#using-filter-widgets-for-defining-mdx-axes) for using filter widgets to define a
query's axis.

_
