## Table

### Overview

Tables display data as a grid with rows, columns and cells. A table is the most common representation of data. Users can
compare values by filtering, sorting and drilling down on certain topics.

This [report example](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FTable+%26+Pivot+Table%2FTable)
contains examples of tables.

### Data

The table uses a tidy table as its input. 

#### Query Builder

Below we show a typical mapping on the Query Builder for a table.

![Table query builder](images/table-query-builder.png)

This example sets `Continent` on the table rows and shows `Amount` as the values.

#### MDX Query 

Below we show a typical MDX query for a table using the sales cube. 

```
SELECT 
    [Measures].[Amount] ON 0,
    [Geography].[Geography].[Continent] ON 1
FROM [Sales]
```

This example sets `Continent` on the table rows, and shows `Amount` as the values.


The next example shows a query that allows for showing several measures on a same table.

```
SELECT 
    {[Measures].[Amount], [Measures].[#Sales], [Measures].[#Licences]} ON 0,
    [Time].[Time].[Year] ON 1
FROM [Sales]
```

The 'Years' are on the rows and the three measures on the columns.


The Table should be used for a flat view of the data, i.e. the Table corresponds to the Tidy Table view. The next example shows an example of query which the Table will display `Year` on first column, `Continent` on second column (the `Continent` for each related `Year`) and finally the measure `Amount`.

```
SELECT 
    [Measures].[Amount] ON 0,
    [Time].[Time].[Year] on 1,
    [Geography].[Geography].[Continent] on 2
FROM [Sales]
```

To display the table from the example above with `Year` as columns and `Continent`s' as rows, use the option _Chart_ >
_Axis(1) as Column_.
For more flexibility on axes, use the [Pivot Table](PivotTable.md) widget instead.


### Configuration

#### Appearance

Configure the following options for the table in the _Chart_ tab.

_Apply Header Color_ \
When set, the table will use the tidy column colors to decorate headers, whether the colors have been defined within the
schema (as [Member Properties](../../../../server/mdx/Member%20Custom%20Property.md) for example) or with a color
transformation in the Transformations tab.

_Columns_ \
Columns widths and behaviors can be set under the _Chart_ options:
- 'Fluid' mode (default) allows for having an automatic sizing of columns, even if your theme has responsive behavior. You can also set for your widths to be a multiplier of others, i.e. setting "2,1" on the _Width (CSV)_ field means that the first column will be double the size of all others.
- 'Fixed width' allows to set specific widths in pixels to your columns.
- 'User Resizable' allows for the end user to resize the columns to the desired width.

Some table options can be set:
- _Header Alignment (CSV)_ sets the alignment of header captions. It's a comma separated list of values: 'left', 'center', 'right', 'auto'. The last value repeats itself.
- _Cell Alignment (CSV)_ sets the alignment of the table values. It's a comma separated list of values: 'left', 'center', 'right', 'auto'. The last value repeats itself.
- _Visible (CSV)_ sets if the columns are visible. It's a list of boolean values: 'true' and 'false'. The last value repeats itself.
- _Pinned (CSV)_ sets if the columns are pinned. A list of values: 'left', 'right' o 'no'. The last value repeats itself.
- _Orderable (CSV)_ allows to reorder columns (not their content). A list of boolean values: 'true', 'false'. The last value repeats itself.

_Columns Header Menu_ \
This allows to add functionalities to the column headers such as sorting arrows or a menu listing pinnable, hideable, filterable, sortable options. Each column header can have its individual menu configuration.

'Export Original Table', if active, allows to export the table in its original state, i.e. resetting any of the functionalities listed above back to their original state. If inactive, the table will be exported in the state the user sees at the moment of the export.

_Footer_ \
Tables can have Footer with a certain number of information that can be set under the _Chart_ options:
- 'Row Count': total number of rows
- 'Selected Row Count': number of selected rows (useful when Multi selection is activated)
- 'Pagination': number of pages and customizable rows per page.

If the Auto Expand functionality is activated, the Footer does not make sense to be used.

#### Auto Expand
Under the _Box_ configurations, the Auto Expand functionality allows for expanding the Table's height automatically. All charts that are positioned below the Table will be pushed down to appear beneath the new Table height. 

This is particularly useful on two use cases:
- Live data dashboards, no manual intervention is therefore necessary
- Printing layouts, this functionality will split the table in the needed number of pages.


#### Cell Renderer

Table cells can display different cell renderers (Transformation > Cell Renderer) instead of the value itself only. Read
more about the available Cell Renderers [here](../misc/CellRenderers.md).

Check
this [report](http://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3report=shared%3A%2FLive+Demo%2FTable+%26+Pivot+Table%2FTable)
for live examples.

#### Coloring

For coloring the pivot tables cells, check this [page](../../../howto/Coloring.md) for different coloring methods.

_
