## Pivot Table

### Overview

Pivot tables display data as a grid with rows, columns and cells. Compared to a flat table, a pivot table is good at displaying aggregated data, showing subtotals of rows or columns and doing drill-downs. 

Note that pivot tables currently only work with MDX sources.

This [report example](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FTable+%26+Pivot+Table%2FPivot+Table)
contains examples of pivot tables.


### Data

The pivot table uses a tidy table as its input. However, it only works when the table is the result of an MDX query. Also, only transformations that work on the cells work. This includes cell renderers, but excludes transformations that add columns or rows. 

For tables that show the tidy table with transformations, we recommend using the [flat table](Table.md).


#### Query Builder

Below we show a typical mapping on the Query Builder for a pivot table.

![pivot table query builder](images/pivot-table-query-builder.png)

This example sets `Continent` on the pivot table rows, `Year` on the columns and shows `Amount` as the values.


#### MDX Query

Below we show a typical MDX query for a table using the sales cube.

```
SELECT
    [Measures].[Amount] ON 0, 
    [Geography].[Geography].[Continent] ON 1
FROM [Sales]
```
    
This example sets `Continent` on the pivot table rows, and shows `Amount` as the values.

The main advantage of the pivot table is that it can show an aggregated view of data. They allow for grouping data and displaying subtotals. For example, the `[Geography].[Geography]` hierarchy contains three levels: Continent, Country, City. When adding the first level (`[Geography].[Geography].[Continent]`) to one of the axes of your query, the pivot table allows to expand a continent into its countries and then cities, displaying the respective subtotals. The same applies to the Time hierarchy (Year, Quarter, Month, Day) on the example below:

```
SELECT     
    [Measures].[Amount] ON 0,    
    [Geography].[Geography].[Continent] on 1,    
    [Time].[Time].[Year] on 2
FROM [Sales]
```

### Configuration

#### Appearance

Configure the following options for the pivot table in the _Chart_ tab.

_Apply Header Color_ \
When set, the table will use the tidy column colors to decorate headers, whether the colors have been defined within the
schema (as [Member Properties](../../../../server/mdx/Member%20Custom%20Property.md) for example) or with a color
transformation in the _Transformations_ tab.

_General_ \
_Hover Behavior_ allows for highlighting rows and/or columns on hover. Header options include:
- _Merge Left Header_: merges top left corner into a single cell
- _Wrap Top Header_: display the top header content on multiple lines
- _Flatten Top Header_: removes drilldown and parent/child relations from the top header

_Columns_ \
Columns widths and behaviors can be set under the Chart options.

- 'Fluid' mode (default) allows for having an automatic sizing of columns, even if your theme has responsive behavior.
  You can also set for your widths to be a multiplier of others, i.e. setting "2,1" on the _Width (CSV)_ field means
  that the first column will be double the size of all others.
- 'Fixed width' allows to set specific widths in pixels to your column.
- 'User Resizable' allows for the end user to resize the columns to the desired width.

Some pivot table options can be set:
- _Left Header Text (CSV)_ is the visible text on the first pivot table column. If you have more than one column, deactivate the _General_ > _Merge Left Header_. A comma separated list of values (use $column for the column name). The last value repeat itsef.
- _Left Header Alignment (CSV)_ sets the alignment of the values of the first pivot table column. It's a comma separated list of values: 'left', 'center', 'right'. The last value repeats itself.
- _Header Alignment (CSV)_ sets the alignment of header captions. It's a comma separated list of values: 'left', 'center', 'right'. The last value repeats itself.
- _Cell Alignment (CSV)_ sets the alignment of the pivot table values. It's a comma separated list of values: 'left', 'center', 'right'. The last value repeats itself.
- _Left Header Sortable (CSV)_ defines if the first pivot table column(s) is(are) sortable. It's a comma separated list of values: 'left', 'center', 'right'. The last value repeats itself.
- _Sortable (CSV)_ defines if the pivot table columns are sortable. It's a comma separated list of values: 'left', 'center', 'right'. The last value repeats itself.


#### Auto Expand

Under the Box configurations, the _Auto Expand_ functionality allows for automatically expanding the pivot table's height only, not its width. This is useful when expanding several levels as the pivot table's height is automatically adjusted when drilling down. All charts that are positioned below the pivot table will be pushed down to appear beneath the new pivot table height.

This is particularly useful on two use cases, 1) Live data dashboards, no manual intervention is therefore necessary, 2) Printing layouts, this functionality will split the table in the needed number of pages.

Deactivating this option means that a scrollbar will appear when drilling down into the rows' levels.


#### Cell Renderer

As for tables, pivot table cells can display different cell renderers (_Transformation_ > _Cell Renderer_) instead of the
value itself only. Read more about the available Cell Renderers [here](../misc/CellRenderers.md).

Check
this [report](http://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3report=shared%3A%2FLive+Demo%2FTable+%26+Pivot+Table%2FTable)
for live examples.

#### Coloring

For coloring the pivot tables cells, check this [page](../../../howto/Coloring.md) for different coloring methods.

_
