## Google: KML Map

### Overview

A Google KML Map is a map widget using a KML file as source. The KML file format includes special characteristics such
as markers, images, polygons, URLs, etc. for geographical data.

The [Google KML Map report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FMaps%2FKML+Maps)
contains examples of KML maps.

Refer to the [configuration](../../../gettingstarted/Configuration.md) section to configure your API key.

### Data

#### Table Definition

Since KML Maps data comes from a .kml file given by a URL, it is easiest to use the CSV (table definition)
as the data source in the query tab. An example for a CSV (table definition) with a URL is the following.

| url | 
| :--- | 
| https://developers.google.com/maps/documentation/javascript/examples/kml/westcampus.kml |

You can replace the URL with a link to your own .kml file.

### Configuration

Configure the options for the Google KML Map chart in the _Chart_ tab. 

The KML file already contains most of the configuration for visual features, such as placemarks, overlays, paths and polygons. Therefore, the list of appearance options concern only the map.

#### Appearance

_Map Settings_ \
'Type' allows to define the map look (Satellite, Hybrid, Road Map, etc).

You can set the initial latitude, longitude and zoom in the map as follows. First, get the location and zoom that you
want on the map in the widget. Then, click on the widget's top right menu and select _Set Zoom & Center_.

_Layer Settings_ \
Set here the column of the table that contains the URL for the KML file. In the example
in [table definition](#table-definition) above, the value would be _url_.

Also, here you can activate or deactivate other KML settings such as viewport, screen overlays and info windows.

_
