## Google: Heat Map

### Overview

A Google Heat Map visualizes the intensity of data points on a geographical map. It can be used, for example, to show
income, population density, sales or number of events per region. The heatmap colors red for areas with high intensity
and green for areas with low intensity.

The [Google Heat Map report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FMaps%2FHeat+Maps)
contains examples of heat maps.

Refer to the [configuration](../../../gettingstarted/Configuration.md) section to configure your API key.

### Data

#### Query Builder

![heat map query builder](images/google-heatmap-query-builder.png)

Location should contain the members containing latitude and longitude
as [member properties](../../../../server/mdx/Member%20Custom%20Property.md), use the filter
icon (see image above, green icon) to display the list of available members that contain these properties.

Weight is an optional field that sets the weight for each location. Per default, each location has the same weight. Use
a measure in this field to adjust the weight of each location.

#### MDX Query 

Below we show a typical MDX query for a Google Heat Map using the Sales cube. 

```
SELECT
   {[Measures].[Amount]} ON "weight"
   [Geography].[Geography].[Country].allmembers ON "location"
FROM [Sales]
```

As for the Query Builder above, the location used on the MDX query should contain the longitude and
latitude [member properties](../../../../server/mdx/Member%20Custom%20Property.md).

#### Table Definition

An example for a table definition is the following: 

| latitude | longitude |
| :--- | ---: |
| 37.782551 | -122.445368 |
| 37.782745 | -122.444586 |
| 37.782842 | -122.443688 |
| 37.782919 | -122.442815 |
| 37.782992 | -122.442112 |
| 37.7831   | -122.441461 |
| 37.783206 | -122.440829 |

This data does not have a weight for each location, meaning that each location gets the same weight. In the map, it colors red where there are many points near each other. It colors green or no color in places where there are just a few or no points. 

### Configuration

Configure the options for the Google Heat Map in the _Chart_ tab. The following groups of options are available.

#### Mapping

The Google Heat Map expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_Location_ \
Contains the location of data points, where members should have latitude and longitude
as [member properties](../../../../server/mdx/Member%20Custom%20Property.md).

_Latitude_ \
Contains the values for the latitude. Per default, the chart uses the values of the @ic3Lat property.

_Longitude_ \
Contains the values for the longitude. Per default, the chart uses the values of the @ic3Long property.

_Weight_ \
Optional, contains a numerical value that sets the data point weights.

#### Appearance

_Map Settings_ \
_Type_ allows to define the map look (Satellite, Hybrid, Road Map, etc.).

You can set the initial latitude, longitude and zoom in the map as follows. First, get the location and zoom that you want on the map in the widget. Then, click on the widget's top right menu and select _Set Zoom & Center_.

_Layer Settings_ \
_Color Gradient_ allows to directly select the gradient instead of going through a Transformation.

Set the radius of influence for each data point under _Radius_; you can also define its _Opacity_ from 0 to 1.

### Best practices

#### Balanced Radius

You can adjust the influence of each datapoint by adjusting the radius in _Layer Settings_. Fine-tune this to the number
of data points that you have. For data points that are close to each other, a too large radius makes the precise
location of a point on the map difficult to read. However, when data points that are more dispersed, a larger
radius makes the points larger and thus more readable.

_
