## Value Axis

In this setting group, you configure the y-Axis Title Text, minimum and maximum values for the axis, and the Value Format.


#### Axis Title

As a default, the axis takes the caption of the value column as its title. To disable the title, you enter a single space into the field. 

#### Minimum and Maximum

With 'Minimum' and 'Maximum', you can set the range of values to show in the chart. Using these values, the chart tries to find the best value-range meaning the minimum and maximum are not strict. 

If you want to increase the minimum or the maximum, then you can adjust 'Adjust minimum by' and 'Adjust maximum by' to increase the range based on the range that the chart calculated. This is useful for example when value labels fall outside the range. 

#### Include Zero in the Value Axis

With the value axis, a user can read the value of a chart element. You should, however, be considerate with the range of
values you show on the axis. Changing the range can influence the conclusions the viewer draws from the chart. See the
following example.

![Chart YAxis](images/chart-yaxis-range.png)

The chart on the left suggests a steeper increase than the chart on the right. For example, from 6 to 7 suggests a 100%
increase, when in fact it is a 13.8% increase. As a default, we chose to always include zero in the y-axis. You can
override this behavior by disabling 'Always include zero'.

#### Overlapping Labels

When the labels contain large numbers, such as `1,000,000`, then they might overlap if the distance between gridlines is too small. With 'Minimum grid distance', you can control the amount of gridlines to show on the axis. Make this value larger to prevent the labels from overlapping. Another solution is to change the number format.

#### Number Format

You can change the formatting in of the number labels with the _Value format_ field. For example, `#,###.00` always shows two decimals, and `#a` uses a letter to show the size of the value, e.g., `1,000,000` becomes `1M` and `4,000` becomes `4k`.

Note that, if the value format removes numbers after the decimal point, then the labels might repeat the same number.
For example, the labels 11 and 10.5 both convert to 11 if the value format is `#,###.`. To prevent this, you can change
the value format to include decimals, e.g. `#,###.##`.

_
