## TreeMap

### Overview

A tree map is a visualization that shows values as rectangular areas. This chart allows for quick comparison between two
items. For it to work best, we recommend not using too many categories to avoid congestion of the chart.

See
the [tree map example report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FTreemap)
for several examples.

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a tree map.

![TreeMap Query Builder](images/treemap-query-builder.png)

This example shows 'Amount' as the values, i.e., rectangle sizes, per Continent.

#### MDX query

A typical MDX query for the tree map has one measure on the 0 axis, a label hierarchy on the 1 axis, and an optional
level on the 2 axis. Below is an example for a tree map with one level.

```
SELECT 
    [Measures].[Amount] ON 0
    [Geography].[Geography].[Continent] ON 1
FROM [Sales]
```

There is no need to explicitly map the columns _First level_ and _Size_. The chart takes per default the first measure
column as the _Size_, and the first character column as the _First level_. In the example above, the _
First level_ is auto-mapped to `Continent`
, and _Size_ is auto-mapped to the measure `Amount`.

#### Multi level

To show the tree maps in an extra level, you'll need a column that contains groups. In this column, rows that have the
same value are in the same group.

The following is an examples of a query that has a _First level_, and a _Second level_.

```
SELECT
  [Measures].[#Licences] on 0
  [Geography].[Classification].[Hemisphere] * [Customer].[Customer].[Type] on 1
FROM [Sales]
```

For this query to work, you'll need to map `Type` to _Second level_.

### Configuration

Configure the options for the tree map in the _Chart_ tab. The following groups of options are available.

#### Mapping

The bar chart expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_First Level_ \
The values in this column are the labels for the tree items.

_Second Level_ \
This column groups the labels in _First level_. This way, the chart shows a level in the tree items.

_Size_ \
A numeric column with the relative sizes of the tree items.

#### Appearance

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Tree map_ \
_Color_ contains the colors for each tree item. If undefined, the chart uses the colors from either _Second level_ (if
available), _First level_, or from the default theme palette. See also this [page](../../../howto/Coloring.md) for different coloring methods.

### Best Practices

#### When to Use a Legend

When having a second level in the tree map, we recommend enabling the legend so that end-users can distinguish between
the different levels.

_

