## Scatter Plot

### Overview

A scatter plot shows items on an x and y coordinate plane. This is useful for visually detecting correlations between x
and y, or for seeing what items are outliers and deserve attention. An example of the latter is if you divide the
plotting area in 4 sub-areas. Then, items that fall in the top right area deserve attention.

For examples,
see [this report with scatter plots](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FScatter).

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a scatter plot.

![Scatter Query Builder](images/scatter-query-builder.png)

This example sets '#Sales' on the horizontal axis of the chart, 'Amount' on the vertical, and 'Amount AVG' as the bubble
sizes.

To create a scatter plot with groups, add an element in the _Group by_ field, for example, `Type`.

#### MDX Query

The following is an example of a valid MDX query for the scatter plot. 
```
SELECT
{[Measures].[Amount],[Measures].[#Sales]} ON 0
[Time].[Time].[Month] ON 1
FROM [Sales]
```


This next example shows a valid MDX query for a scatter plot containing groups.
```
SELECT
{[Measures].[Amount],[Measures].[#Sales]} ON 0
[Time].[Time].[Month] ON 1
[Customer].[Customer].[Type] ON 2
FROM [Sales]
```

This produces the following tidy table.

|&nbsp;|Month<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Type<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|#Sales<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|---:|
|0|2018 Jan|Business|€54,000|16|
|1|2018 Jan|Consumer|€5,050|13|
|2|2018 Feb|Business|_\<null>_|_\<null>_|
|...|...|...|...|...|
|111|2022 Aug|Consumer|€4,000|16|
|112|2022 Sep|Business|_\<null>_|_\<null>_|
|113|2022 Sep|Consumer|€1,200|1|

For this query, the scatter plot auto-maps `Month` to 'Label', `Amount` to 'X value' and `#Sales` to 'Y value'. Because this data is grouped, you'll have to map `Type` to 'Group by'.

### Configuration

Configure the options for the scatter plot in the _Chart_ tab. The following groups of options are available.

#### Mapping

The scatter plot expects a [tidy table](../../../tidyTable/TidyTable.md) where each row is a point in the chart. Each row has the following columns.

_Label_ \
A column that contains the labels for the points in the scatter plot.

_X-Values_ \
Contains the x-coordinate of the point.

_Y-Value_ \
Contains the values that determine the size of each slice.

_Group By_ (optional) \
If defined, the point is in this group. Each group has its own legend item and its own color.

#### Appearance

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_Scatter Series_ \
In _Color_, you can set the color of the point. If you set a transformation on one of the columns in the table, then
this will auto map to that color. See also this [page](../../../howto/Coloring.md) for different coloring methods.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Trend Line_ \
See [how to configure a trend line](../topics/Am4TrendLine.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

_
