## Sankey Diagram

### Overview

A sankey chart shows flows between categories, for example, the flow of money between accounts or the flow of energy/commodities in a process. Sankey diagrams can be hard to interpret for users that have not seen such a diagram before.

A common usage for sankey charts is for showing different stages in a process. Take a hiring process for example, the
company calls respondents to the job offer, after which it accepts fewer applicants for in person interviews. A sankey
would show this like the image below.

![Sankey Example](images/sankey-example.png)

The [sankey example report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FSankey)
shows more examples.

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a sankey chart.

![Sankey Typical Query Builder](images/sankey-query-builder-1.png)

This example shows all members of the 'Product' hierarchy, keeping its structure defined on your schema.

To show nodes from different hierarchies, set the mapping as follows:

![Sankey Multi Hierarchy Query Builder](images/sankey-query-builder-2.png)

Note that, manually adding levels of a same hierarchy will not keep the hierarchical structure of the data. Create
therefore separate hierarchies for the different levels.

#### MDX Query

Below is an example for an MDX query.
```
SELECT
    [Measures].[#Sales] ON 0,
    [Geography].[Classification].[City] *
    [Geography].[Classification].[Hemisphere] *
    {
        [Geography].[Classification].[Country].&[CN],
        [Geography].[Classification].[Country].&[FR],
        [Geography].[Classification].[Country].&[BR],
        [Geography].[Classification].[Country].&[ZA]
    } ON 1
FROM [Sales]
```

This produces the following table.

|&nbsp;|City<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Hemisphere<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Country<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Sales<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|:---|---:|
|0|Brasilia|Global South|Brazil|16|
|1|Beijing|Global South|China|26|
|2|Pretoria|Global South|South Africa|99|
|3|Johannesburg|Global South|South Africa|99|
|4|Durban|Global South|South Africa|81|
|5|Paris|Global North|France|315|
|6|Marseille|Global North|France|171|
|7|Lyon|Global North|France|180|

In this example, each city, hemisphere and country is a node. The flows are the pairs between columns, e.g., 
- (Paris → Global North: 315), 
- (Johannesburg → Global South: 99), 
- (Global South → South Africa: 279).

The chart aggregates repeated pairs.

Another example is the following query that has a hierarchy.

```
SELECT 
[Measures].[#Sales] ON 0
[Product].[Product].allmembers ON 1
FROM [Sales]
```

This query outputs the following table. Note the hierarchy tree structure in the Product column.

|&nbsp;|Product<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Sales<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|
|0|All Products|2261|
|1|&nbsp;&nbsp;icCube|2261|
|2|&nbsp;&nbsp;&nbsp;&nbsp;License|1617|
|3|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Personal|593|
|4|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Server|1024|
|5|&nbsp;&nbsp;&nbsp;&nbsp;Support|644|
|6|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Gold|184|
|7|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Platinum|88|
|8|&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Silver|372|

Having a single hierarchy in the MDX result produces a tree-like sankey diagram. In this example, the nodes are all the members in Product. The flows move down the tree, resulting in:
- (All Products → icCube: 2261), 
- (icCube → Licence: 1617), 
- (Licence → Personal: 593), 
- ..., 
- (Support → Silver: 372).

### Configuration

Configure the options for the sankey diagram in the Chart tab. The following groups of options are available.

#### Mapping

The sankey diagram expects a tidy table. 

_Value_ \
A column containing the values for the sankey.

The sankey does not use a mapping for the categories. Instead, it uses all character columns in the chart.

#### Appearance

_Flow_ \
In this setting group you can adjust how the chart renders flows: the flows' color, opacity, tension (straight or curved) and tooltip.  Colors on the sankey can be set thanks to color transformations, read more [here](../../../howto/Coloring.md).

_Node_ \
Here you can adjust how the chart renders nodes: the nodes' thickness and tooltip.

_Sankey Diagram_ \
Here you can control the orientation of the chart. The 'Merge Nodes' option allows to merge the nodes together if the query returns the same set of incoming and outgoing nodes.

_
