## Column Chart

### Overview

A column chart is a visualization that shows values as bars along a common axis. It is used to compare values over time
or between categories. The human eye can quickly compare sizes of columns, meaning it is a good candidate for questions
such as ”What is the largest or smallest?” or ”Is there a trend?”.

The [column example report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FColumn)
contains examples of column charts.

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a column chart.

![Column Query Builder](images/column-query-builder.png)

This example sets `Continent` on the horizontal axis of the chart, and shows `#Customers` as the values, i.e., column
sizes.

#### MDX Query

A typical MDX query for the column chart has one measure on the 0 axis, and a set of members (e.g., a hierarchy, a
level, etc.) on the 1 axis. For example:

```
SELECT 
    [Measures].[Amount] ON 0
    [Geography].[Geography].[Continent] ON 1
FROM [Sales]
```

Once the MDX result is converted to a [tidy table](../../../tidyTable/TidyTable.md), there is no need to explicitly map
the columns _Category_, _Value_ and _Color_. The chart takes per default the first measure column as the _Value_ and
the first non-measure column as the _Category_. In the example above, the `Continent` level is used as the _Category_,
and the measure `Amount` as the _Value_.

#### Grouping

When using more than one category, the columns have to be explicitly mapped to the chart in _Chart_ > _x-Axis_. The
following are two examples of queries with more than one category.

```
SELECT
  [Measures].[#Licences] on 0
  [Geography].[Classification].[Hemisphere] * [Customer].[Customer].[Type] on 1
FROM [Sales]

```
or
```
SELECT
  [Measures].[#Licences] on 0
  [Geography].[Classification].[Hemisphere] on 1
  [Customer].[Customer].[Type] on 2
FROM [Sales]

```

For both queries, mapping `Type` to _Axis_ and `Hemisphere` to _Group_ gives a correctly grouped column chart.


#### Table Definition

An example for a table definition is the following:

| date | value |
| :--- | ---: |
| 2017-12-31T23:00:00.000Z | 4500 |
| 2017-12-31T23:00:01.000Z | 2690 |
| 2017-12-31T23:00:02.000Z | 7000 |
| 2017-12-31T23:00:03.000Z | 4900 |
| 2017-12-31T23:00:04.000Z | 5000 |
| 2017-12-31T23:00:05.000Z | 5500 |
| 2017-12-31T23:00:06.000Z | 4200 |

To render this example on a date axis, the date column must be converted to a datetime column. For that, use the
'Set Type' transformation, choose this column, and set it to datetime. The chart will automatically map column 'date' as
the axis labels and column 'value' as the values.

### Configuration

Configure the options for the column chart in the _Chart_ tab. The following groups of options are available.

#### Mapping

The column chart expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_Value_ \
Contains the values for columns. This field can be set in _Y-Axis_ > _Value_. Per default, the chart uses the first
column with numeric values.

_Axis_ \
Contains the labels or date-times for the horizontal axis. Per default, the chart uses the first column of either type
character or type datetime.

_Group_ \
Optional, add an extra dimension to compare the values against. This clusters columns that have the same value in the
column mapped to _Group_.

_Level_ \
This divides the axis into a different section for each unique value in this column, resulting in a hierarchy on the axis.
Note, this only works when the mapped column in _Axis_ is of type character.

_Color_ \
contains the colors for each column. If undefined, the chart uses the colors from either the color property of _Group_
or from the default theme palette applied on the values in _Group_. If _Group_ is unmapped, it takes the default theme
color from the palette.

#### Appearance

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_Column Series_ \
Map _Color_ to a column in the tidy table to configure the colors of the columns. See also this [page](../../../howto/Coloring.md) for different coloring methods.

The value in _Tooltip_ is the value
shown when hovering over the column when the _Chart Cursor_ is enabled.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Trend Line_ \
See [how to configure a trend line](../topics/Am4TrendLine.md).

_Y-Axis Range_ \
See [here how to configure a line or range](../topics/Am4ValueAxisRange.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

### Best practices

#### Grouping Categories

When grouping categories, see the section [Grouping](#grouping). It is best to color according to the _Group_
category.

Make sure the quantity of data (number of _Group_ and _Axis_ members) is not that important to make the Column chart
easily readable.

#### Axis Origin

It is a best practice to start the x-Axis and y-Axis on 0 not to mislead the business user reading the chart.

#### Limited Number of Categories

Prefer choosing the Column Chart when you have a low or limited number of categories.

If your data contains a high quantity of categories, the Column Chart may not be the best choice. You can still use the
scrollbar, or the cursor that allows to zoom in, but it is best to use the Line Chart or Bubble Chart.

#### Sorting

If the data doesn't naturally have a logical order, it is visually interesting to have the data sorted to
compare categories.

#### Multiple Measures

See [Showing multiple measures in a chart](../topics/Am4AddMultiMeasure.md).

_
