## Area Chart

### Overview

An area chart is basically a line chart with the area under the chart colored. Because of this, it is usually not a good
idea group this chart into multiple series, because the areas might overlap. If the chart requires groups, we recommend
using either the line chart, or the stacked area chart.

You can find examples of the area
chart [here](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FArea).

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for an area chart.

![Area Query Builder](images/area-query-builder.png)

This example sets `Continent` on the horizontal axis of the chart, and shows `Amount` as the values.

#### MDX Query

Below we show a typical MDX query for an area chart using the sales cube.

```
SELECT 
    [Measures].[Amount] ON 0
    [Geography].[Geography].[Continent] ON 1
FROM [Sales]
```

This example show the same result as the Query Builder result.

The next example shows a query for grouped data.

```
SELECT 
    [Measures].[Amount] ON 0
    [Time].[Time].[Year] on 1
    [Product].[Product].[Category] ON 2
FROM [Sales]
```

To show multiple area series in the chart, map _X-Axis_ > _Group_ to the column named `Category`. The chart will
automatically map the axis and values.

#### Table Definition

An example for a table definition is the following:

|date|value|
| :--- | ---: |
|2017-12-31T23:00:00.000Z| 4500 |
|2017-12-31T23:00:01.000Z| 2690 |
|2017-12-31T23:00:02.000Z| 7000 |
|2017-12-31T23:00:03.000Z| 4900 |
|2017-12-31T23:00:04.000Z| 5000 |
|2017-12-31T23:00:05.000Z| 5500 |
|2017-12-31T23:00:06.000Z| 4200 |

To render this example on a date axis, the date column must be converted to a datetime column. For that, use the 'Set
Type' transformation, choose this column, and set it to datetime. The chart will automatically map column 'date' as the
axis labels and column 'value' as the values.

### Configuration

Configure the options for the area chart in the _Chart_ tab. The following groups of options are available.

#### Mapping

The area charts expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_X-Axis_ \
Contains the labels or date-times for the horizontal axis. Per default, the chart uses the first column of either type
character or type datetime.

_Y-Axis_ \
Contains the values for the area. This field can be set in _Y-Axis_ > _Value_. Per default, the chart uses the first
column with numeric values.

_Group_ \
Optional, create an area series in the chart for each different group in this column.

_Level_ \
This divides the axis into a different section for each unique value in this column. Note, this only works when the mapped
column in _Axis_ is of type character.

#### Appearance

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_Area series_ \
_Color_ controls the colors of the area bullets. The first color in this column, and in the group if grouped, determines
the color for the area. If _Color_ is undefined, the chart uses the colors from either the color property of _Group_ or
from the default theme palette applied on the values in _Group_. If _Group_ is unmapped, it takes the default theme
color from the palette. See also this [page](../../../howto/Coloring.md) for different coloring methods.

The options _Hide Line Bullets_ hides the bullets on the area by making them invisible.

In the option _Tooltip_, you configure the tooltip for hovering the area chart. To actually see the tooltip, the option
_Chart Cursor_ must be enabled. The background-color of the tooltip is the sames as the color of the bullet.

You can control the opacity of the area of the series with the option _Area Fill Opacity_. This option takes a value
between 0 and 1, where 0 means that the area is fully transparent (invisible) and 1 means that the area is not
transparent at all.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Trend Line_ \
See [how to configure a trend line](../topics/Am4TrendLine.md).

_Y-Axis Range_ \
See [here how to configure a line or range](../topics/Am4ValueAxisRange.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

### Best practices

#### Groups

For grouped data, we recommend using either the stacked area chart, or a line chart, because the opacity of the area
makes groups overlap and not look nice.

#### Many Data Points

When the data contains many data-points, for example when visualizing the output of a sensor over time, we recommend
hiding the bullets in _Area Series_ > _Hide Line Bullets_. This way, the data-points are not obscured by many
overlapping bullets.

#### Multiple Measures

See [Showing multiple measures in a chart](../topics/Am4AddMultiMeasure.md).

_
